package com.cftech.pay.api.impl;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.pay.api.WeiXinPayInterface;
import com.cftech.pay.model.PayRecord;
import com.cftech.pay.service.PayRecordService;
import com.cftech.sys.security.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by user on 2017/5/11.
 */
@Service("weiXinPayInterface")
@com.alibaba.dubbo.config.annotation.Service(interfaceClass=WeiXinPayInterface.class, protocol={"dubbo"}, timeout=10000,retries=0)
public class WeiXinPayImpl implements WeiXinPayInterface {

    @Autowired
    private PayRecordService payRecordService;

    @Override
    public JSONObject doPay(String... params) {
        JSONObject json = new JSONObject();
        json.put("errorNo","0");
        return json;
    }

    @Override
    public JSONObject listData(int iDisplayStart, int iDisplayLength, PayRecord payRecord) {
//        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
//        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(payRecord.getSrcid())) {
            conds.like("srcid", payRecord.getSrcid());
        }
        if (!StringUtils.isEmpty(payRecord.getSrctype())) {
            conds.like("srctype", payRecord.getSrctype());
        }
        if (!StringUtils.isEmpty(payRecord.getMch_id())) {
            conds.like("mch_id", payRecord.getMch_id());
        }
        if (!StringUtils.isEmpty(payRecord.getErr_code())) {
            conds.like("err_code", payRecord.getErr_code());
        }
        if (!StringUtils.isEmpty(payRecord.getErr_code_des())) {
            conds.like("err_code_des", payRecord.getErr_code_des());
        }
        if (!StringUtils.isEmpty(payRecord.getOpenid())) {
            conds.like("openid", payRecord.getOpenid());
        }
        if (!StringUtils.isEmpty(payRecord.getTrade_type())) {
            conds.like("trade_type", payRecord.getTrade_type());
        }
        if (!StringUtils.isEmpty(payRecord.getIs_subscribe())) {
            conds.like("is_subscribe", payRecord.getIs_subscribe());
        }
        if (!StringUtils.isEmpty(payRecord.getBank_type())) {
            conds.like("bank_type", payRecord.getBank_type());
        }
        if (!StringUtils.isEmpty(payRecord.getTotal_fee())) {
            conds.like("total_fee", payRecord.getTotal_fee());
        }
        if (!StringUtils.isEmpty(payRecord.getFee_type())) {
            conds.like("fee_type", payRecord.getFee_type());
        }
        if (!StringUtils.isEmpty(payRecord.getCash_fee())) {
            conds.like("cash_fee", payRecord.getCash_fee());
        }
        if (!StringUtils.isEmpty(payRecord.getCash_fee_type())) {
            conds.like("cash_fee_type", payRecord.getCash_fee_type());
        }
        if (!StringUtils.isEmpty(payRecord.getTransaction_id())) {
            conds.like("transaction_id", payRecord.getTransaction_id());
        }
        if (!StringUtils.isEmpty(payRecord.getOut_trade_no())) {
            conds.like("out_trade_no", payRecord.getOut_trade_no());
        }
        if (!StringUtils.isEmpty(payRecord.getAttach())) {
            conds.equal("attach", payRecord.getAttach());
        }
        if (!StringUtils.isEmpty(payRecord.getTime_end())) {
            conds.equal("time_end", payRecord.getTime_end());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<PayRecord> list = payRecordService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = payRecordService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }
}
