package com.cftech.cms.cfarticle.service;

import com.cftech.cms.cfarticle.model.Cfarticle;
import com.cftech.cms.cfarticle.model.CfarticleColumnDto;
import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;

import java.util.List;

/**
* CMS文章管理Service
*
* @author lisw
* @date: 2017-05-03 10:51
*/
public interface CfarticleService extends GenericService<Cfarticle> {

    /**
     * 分页查询
     *
     * @param conds    条件
     * @param sort     排序
     * @param page     起始条数
     * @param pageSize 分页大小
     * @return
     */
    List<CfarticleColumnDto> fetchSearchByPageTemp(Conds conds, Sort sort, int page, int pageSize,Long specialId);



    /**
     * 查询总条数
     *
     * @param conds 条件
     * @return 条数
     */
    int countTemp(Conds conds);

    List<Cfarticle> fetchSearchByPageInOrder(Conds conds,String articles);

    int countReview(Conds conds);
}
