package com.cftech.questionnaire.core.questions.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.questionnaire.core.paper.dao.PaperLogMapper;
import com.cftech.questionnaire.core.paper.model.PaperLog;
import com.cftech.questionnaire.core.questions.dao.QuestionsMapper;
import com.cftech.questionnaire.core.questions.model.Questions;
import com.cftech.questionnaire.core.questions.service.QuestionsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 问卷题库ServiceImpl
 *
 * @author wxf
 * @date: 2017-05-24 11:43
 */
@Service("questionsService")
public class QuestionsServiceImpl extends GenericServiceImpl<Questions> implements QuestionsService {

    @Autowired
    @Qualifier("questionsMapper")
    private QuestionsMapper questionMapper;

    @Autowired
    private PaperLogMapper paperLogMapper;

    @Override
    public GenericDao<Questions> getGenericMapper() {
        return questionMapper;
    }

    @Override
    public List<Questions> fetchSearchVOByPage(Long pId, Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("pId", pId);
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return questionMapper.fetchSearchVOByPage(params);
    }

    @Override
    public int count(Long pId, Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("pId", pId);
        return questionMapper.count(params);
    }

    @Override
    public void addpaperlog(String question) {
        JSONArray jsonArray = JSON.parseArray(question);
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (jsonObject.getString("type").equals("BLANKFILL")) { //填空
                PaperLog paperLog = new PaperLog();
                paperLog.setPaperId(Long.valueOf(jsonObject.getString("activid")));
                paperLog.setPalyerId(jsonObject.getString("openid"));
                JSONObject json = JSON.parseObject(jsonObject.getString("value"));
                paperLog.setOption_con(json.getString("option_con"));
                paperLog.setSubject_id(Long.valueOf(json.getString("sid")));
                paperLogMapper.save(paperLog);
            } else if (jsonObject.getString("type").equals("SINGLESEL")) { //单选
                PaperLog paperLog = new PaperLog();
                paperLog.setPaperId(Long.valueOf(jsonObject.getString("activid")));
                paperLog.setPalyerId(jsonObject.getString("openid"));
                JSONObject json = JSON.parseObject(jsonObject.getString("value"));
                paperLog.setOption_id(Long.valueOf(json.getString("oid")));
                paperLog.setSubject_id(Long.valueOf(json.getString("sid")));
                paperLogMapper.save(paperLog);
            } else { //多选
                JSONArray jsonArray1 = JSON.parseArray(jsonObject.getString("value"));
                for(int k=0;k<jsonArray1.size();k++){
                    PaperLog paperLog = new PaperLog();
                    JSONObject jsonobj = jsonArray1.getJSONObject(k);
                    paperLog.setPaperId(Long.valueOf(jsonobj.getString("activid")));
                    paperLog.setPalyerId(jsonobj.getString("openid"));
                    paperLog.setOption_id(Long.valueOf(jsonobj.getString("oid")));
                    paperLog.setSubject_id(Long.valueOf(jsonobj.getString("sid")));
                    paperLogMapper.save(paperLog);
                }
            }
        }
    }
}