package com.cftech.mp.reply.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.core.util.StringUtils;
import com.cftech.mp.reply.model.Reply;
import com.cftech.mp.reply.service.ReplyService;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;

import net.sf.json.JSONArray;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/** 
 * @author 作者 lisw: 
 * @version 创建时间：2016年10月27日 上午11:00:34 
 * 公众号回复消息 
 */
@Controller
@RequestMapping("/a/wx/reply")
public class ReplyController {
	
	@Autowired
	private ReplyService replyService;
	
	
	@RequestMapping(value={"list",""},method = {RequestMethod.POST,RequestMethod.GET})
	@RequiresPermissions(value=PermissionSign.REPLY_VIEW)
	public String list(Model model,Reply reply){
		return "managerwechat/replylist";
	}
	
	@RequestMapping(value="fetchData",method = {RequestMethod.POST,RequestMethod.GET})
	@ResponseBody
	public JSONObject fetchData(HttpServletRequest request, int iDisplayStart, int iDisplayLength, Reply reply){
		 Long id=UserUtils.getmpaccounts(request);
			Sort sort = new Sort("updatetime", OrderType.DESC); 
			Conds conds = new Conds();
			conds.equal("accountsid", id);
			if(StringUtils.isNotBlank(reply.getSendType())){
				conds.like("send_type",reply.getSendType());
			}
			if(StringUtils.isNotBlank(reply.getReplyType())){
				conds.like("reply_type",reply.getReplyType());
			}
			conds.equal("delflag", Constants.DEL_FLAG_0);
			JSONObject returnObj = new JSONObject();
			List<Reply> imageText = replyService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
			// 获得总数
			int userCounts = replyService.count(conds);
			returnObj.put("iTotalRecords", userCounts);
			returnObj.put("iTotalDisplayRecords", userCounts);
			returnObj.put("aaData", imageText);
			return returnObj;
	}
	
	@RequestMapping(value="replyform",method = {RequestMethod.POST,RequestMethod.GET})
	@RequiresPermissions(value=PermissionSign.REPLY_EDIT)
	public String replyform(Reply reply,Model model){
		if(reply.getId()!=null){
			reply = replyService.fetchById(reply.getId());
		}
		model.addAttribute("reply", reply);
		return "managerwechat/replyform";
	}
	
	@RequestMapping(value="addreply",method = {RequestMethod.POST})
	@ResponseBody
	public JSONObject addreply(Reply reply,HttpServletRequest request){
		if(StringUtils.equals(reply.getReplyType(),"text")){
			reply.setContentSource(reply.getContentSource().replace("\n", "<br/>"));
		}
		Conds conds = new Conds();
		 Long id=UserUtils.getmpaccounts(request);
		 conds.equal("accountsid",id);
		 conds.equal("send_type",reply.getSendType());
		 conds.equal("delflag",Constants.DEL_FLAG_0);
		 JSONObject rtnJson = new JSONObject();
		 Reply r = replyService.fetchSearchByConds(conds);
		 rtnJson.put("errorNo", 0);
		 try {
			 if(reply.getId()!=null){//修改
				 Reply reReply = replyService.fetchById(reply.getId());
				 if(r!=null && !StringUtils.equals(r.getSendType(),reReply.getSendType()) && reply.getSendType().equals("subscribe")){//关注回复只能设置一个
					 rtnJson.put("errorNo",3);
				 }else{
					 reply.setUpdateBy(UserUtils.getUser().getId());
					 rtnJson.put("errorNo", 2);
					 replyService.update(reply);
				 }
			 }else{//添加
				 if(r!=null && reply.getSendType().equals("subscribe")){//关注回复只能设置一个
					 rtnJson.put("errorNo",3);
				 }else{
					 reply.setAccountsid(id);
					 reply.setCreateBy(UserUtils.getUser().getId());
					 reply.setDelflag(Constants.DEL_FLAG_0);
					 reply.setUpdateBy(UserUtils.getUser().getId());
					 replyService.save(reply);
				 }
			 }
		} catch (Exception e) {
			e.printStackTrace(); 
			rtnJson.put("errorNo",1);
		}
		 return rtnJson;
	}
	
	@RequestMapping(value = "removereply",method = {RequestMethod.POST})
	@RequiresPermissions(value=PermissionSign.REPLY_EDIT)
	@ResponseBody
	public JSONObject removereply(Long id){
		JSONObject rtnJson = new JSONObject();
		rtnJson.put("errorNo",0);
		try {
			if(id!=null){
				replyService.delete(id);
			}
		} catch (Exception e) {
			rtnJson.put("errorNo",1);
		}
		return rtnJson;
	}
}
 