package com.cftech.mp.fans.service;

import com.cftech.core.feature.orm.mybatis.Page;
import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.mp.fans.model.MpFanssEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface MpFanssService extends GenericService<MpFanssEntity> {

	long insert(MpFanssEntity record);

	List<MpFanssEntity> getMpFans(Long userid);

	public void updateByPrimaryKey(MpFanssEntity mpAccounts);

	int deleteByPrimaryKey(Long id);

	MpFanssEntity getDetail(Long id);

	List<MpFanssEntity> getAllMpAccounts();

	List<MpFanssEntity> getMpFansAndPage(Page<MpFanssEntity> page,
                                         @Param("userid") Long userid);

	Long selectFannscounts(@Param("userid") Long userid);


	MpFanssEntity getWxUser(String openid);

	// 根据公众号ID更新获取详细信息
	List<String> getAllWxUser(String AccountId);

	// 根据openid更新粉丝信息
	public void updateByOpenId(MpFanssEntity mpAccounts);

	// 根据openId删除粉丝
	int deleteByOpenId(String openid);
	
	//根据省市查询粉丝
	public List<String> fannsByArea(String areaName, String accountsid, String sex, String tags, String storeIds);

	List<MpFanssEntity> fetchSearchByPage(Conds conds, Sort sort,
                                          int iDisplayStart, int iDisplayLength, String areaname);

	int count(Conds conds, String areaname);
	
	/**
     * 分页查询
     *
     * @return
     */
    List<MpFanssEntity> fetchSearchByPageStore(Conds conds, Sort sort, int page, int pageSize, String areaName);
    /**
     * 修改粉丝标签
     * */
	boolean updateLabelByid(Map<String, Object> map);

	String findopenidById(Long id);


	/**
	 * 批量修改粉丝标签
	 */
	Integer updateBatchLabelByTags(String []openIds,Long accountsId,Integer tagsId);

}
