package com.cftech.membercard.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.collection.service.CollectionService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.member.model.Member;
import com.cftech.member.service.MemberService;
import com.cftech.membercard.model.McardExplain;
import com.cftech.membercard.model.mCardDMSCode;
import com.cftech.membercard.service.McardExplainService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * Created by lisw on 2017/10/11.
 */
@Slf4j
@RestController
@RequestMapping("mobile/auth/mcard/explain")
public class MobileMcardExplainController {

    @Autowired
    private MemberService memberService;

    @Autowired
    private McardExplainService mcardExplainService;

    @Autowired
    private CollectionService collectionService;


    @RequestMapping(value="/detail",method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject detail(Long memberId){
        JSONObject rtnJson = new JSONObject();

        try{
            Member member = memberService.fetchById(memberId);
            JSONObject objJson = new JSONObject();
            objJson.put("mCardNo",member.getMemberId());
            String dmsLevel = member.getLevel();
            String gradeNo = mCardDMSCode.getName(dmsLevel);
            if(StringUtils.isNotBlank(gradeNo)){
                Conds conds = new Conds();
                conds.equal("grade",gradeNo);
                McardExplain mcardExplain = mcardExplainService.fetchSearchByConds(conds);
                Conds allConds = new Conds();
                allConds.equal("del_flag",0);
                Sort sort = new Sort("grade", OrderType.ASC);
                List<McardExplain> mcardExplainList = mcardExplainService.fetchSearchByPage(allConds,sort,0,0);
                for(McardExplain mcardExplain1 : mcardExplainList){
                    if(mcardExplain.getGrade().equals(mcardExplain1.getGrade())){
                        mcardExplain1.setIsMember("0");
                    }else{
                        mcardExplain1.setIsMember("1");
                    }
                }
                rtnJson.put("errorNo","0");
                rtnJson.put("memberNo",member.getMemberId());
                rtnJson.put("data",mcardExplainList);
            }else{
                rtnJson.put("errorNo","2");
                rtnJson.put("errorMsg","等级编码为空");
            }
        }catch (Exception e){
            rtnJson.put("errorNo","1");
            e.printStackTrace();
        }
        return rtnJson;
    }



    @RequestMapping(value="/detailNo",method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject detailNo(String levelNo){
        JSONObject rtnJson = new JSONObject();
        try{
            if(StringUtils.isNotBlank(levelNo)){
                Conds conds = new Conds();
                conds.equal("grade",levelNo);
                McardExplain mcardExplain = mcardExplainService.fetchSearchByConds(conds);
                rtnJson.put("errorNo","0");
                rtnJson.put("data",mcardExplain);
            }else{
                rtnJson.put("errorNo","2");
                rtnJson.put("errorMsg","等级编码为空");
            }
        }catch (Exception e){
            rtnJson.put("errorNo","1");
            e.printStackTrace();
        }
        return rtnJson;
    }
}
