package com.cftech.shop.qrcode.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.cftech.shop.qrcode.model.QyUser;
import com.cftech.shop.qrcode.model.WxQrcode;
import com.cftech.shop.qrcode.dao.WxQrcodeMapper;
import com.cftech.shop.qrcode.model.vo.WxQrcodeVO;
import com.cftech.shop.qrcode.service.WxQrcodeService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import com.cftech.core.sql.Sort;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 二维码ServiceImpl
 *
 * @author Neil
 * @date: 2017-12-04 17:56
 */
@Service("wxQrcodeService")
public class WxQrcodeServiceImpl extends GenericServiceImpl<WxQrcode> implements WxQrcodeService {

    @Autowired
    @Qualifier("wxQrcodeMapper")
    private WxQrcodeMapper wxQrcodeMapper;

    @Override
    public GenericDao<WxQrcode> getGenericMapper() {
        return wxQrcodeMapper;
    }

    @Override
    public List<WxQrcode> fetchSearchByPage(Long orgId, Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();

        params.put("orgId", orgId);
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return wxQrcodeMapper.fetchSearchByPage(params);
    }

    @Override
    public List<WxQrcodeVO> fetchSearchByPageVO(Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();

        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return wxQrcodeMapper.fetchSearchByPageVO(params);
    }

    @Override
    public int count(Long orgId, Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("conds", conds);
        return wxQrcodeMapper.count(params);
    }

    @Override
    public boolean updateBindId(WxQrcode wxQrcode) {
        return wxQrcodeMapper.updateBindId(wxQrcode) == 1;
    }


    @Override
    public List<WxQrcode> fetchSingleSearchInfo(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return wxQrcodeMapper.fetchSingleSearchInfo(params);
    }

    @Override
    public List<QyUser> fromUser(int type, String name, int page, int pageSize) {
        page = page > 0 ? page : 0;
        pageSize = pageSize > 0 ? pageSize : 0;
        return wxQrcodeMapper.fromUser(type, name, page, pageSize);
    }

    @Override
    public int countUser(int type, String name) {
        return wxQrcodeMapper.countUser(type, name);
    }

    @Override
    public List<WxQrcode> fromOrg(String name, int page, int pageSize) {
        page = page > 0 ? page : 0;
        pageSize = pageSize > 0 ? pageSize : 0;
        return wxQrcodeMapper.fromOrg(name, page, pageSize);
    }

    @Override
    public int countOrg() {
        return wxQrcodeMapper.countOrg();
    }

}