package com.cftech.consultsheet.dao;


import com.cftech.consultsheet.model.ConsultSheet;
import com.cftech.consultsheet.model.ConsultSheetDto;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.util.List;
import java.util.Map;

/**
* 咨询单Mapper
*
* @author Licc
* @date: 2020-09-22 12:06
*/
public interface ConsultSheetMapper extends GenericDao<ConsultSheet> {

    Integer updateDate(@Param("consultId") Long consultId, @Param("status") String status, @Param("description") String description);

    Integer updateStatus(@Param("consultId") Long id, @Param("status") String status, @Param("des") String des);

    List<ConsultSheet> fetchSearchByPage(Conds conds, Sort sort, int page, int pageSize, Long id);

    List<ConsultSheet> consultSheetList(ConsultSheetDto consultSheetDto);

    Integer fetchSearchByCount(Map<String, Object> params);
}