package com.cftech.cos.uploader.category.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.cos.uploader.category.dao.MaterialCategoryMapper;
import com.cftech.cos.uploader.category.model.MaterialCategory;
import com.cftech.cos.uploader.category.service.MaterialCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 问卷分类ServiceImpl
 *
 * @author Neil
 * @date: 2017-05-23 13:24
 */
@Service("materialCategoryService")
public class MaterialCategoryServiceImpl extends GenericServiceImpl<MaterialCategory> implements MaterialCategoryService {

    @Autowired
    @Qualifier("materialCategoryMapper")
    private MaterialCategoryMapper papercategoryMapper;

    @Override
    public GenericDao<MaterialCategory> getGenericMapper() {
        return papercategoryMapper;
    }

    @Override
    public List<MaterialCategory> fetchSearchByPage(Long parentId, Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<>();
        params.put("pId", parentId);
        if (parentId == 0) {
            params.put("pId", parentId);
        } else {
            params.put("pId", "," + parentId);
        }

        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return papercategoryMapper.fetchSearchByPage(params);
    }

    @Override
    public List<MaterialCategory> fetchTreeByPage(Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return papercategoryMapper.fetchTreeByPage(params);
    }

    @Override
    public int count(Long parentId, Conds conds) {
        Map<String, Object> params = new HashMap<>();
        params.put("pId", parentId);
        params.put("conds", conds);
        return papercategoryMapper.count(params);
    }
}