var meetingMaterial = (function () {
  'use strict';
  var MeetingMaterial = function (params) {
    var p = this;
    p.params = {
      appid: '',
      accountsId: '',
      cfApp: null,
      devMode: false,
      dataApi: G.baseUri() + '/mobile/auth/exhibi_sample/getexhibi_sample',
      vt: ''
    };

    for (var param in params) {
      p.params[param] = params[param];
    }
    var cfApp = p.params.cfApp;

    if (p.params.devMode) {
      p.params.dataApi = 'json/exhibi-material.json';
    }

    p.page = 0;
    p.sample_title='';
    p.loading = false;
    p.english = cfApp.getQueryString('english') == 1 ? true : false;
    console.log(p.english);
    /**
     * 判断app字段
     * @returns 是否app有值
     */
    var validAppField = function () {
      if (!p.params.appid || p.params.appid == '') {
        return false;
      } else {
        return true;
      }
    };

    /**
     * 确认初始化的app 和tokenId 两个值是否都存在
     * 如果不存在则获取一次,获取不到则初始化失败
     * @returns 初始化基础字段是否成功
     */
    var initBaseFields = function () {
      if (!validAppField()) {
        p.params.appid = cfApp.getQueryString('appid');
        //p.params.accountsId = cfApp.getQueryString('accountsId');
      }



      //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
      if (!validAppField()) {
        if (p.params.cfApp) {
          p.params.appid = cfApp.getAppId();
          //p.params.tokenId = cfApp.getTokenId();
        }
      }
      p.empInfo = cfApp.getMpInfo();
      p.params.accountsId = p.empInfo.accountsId;
      return validAppField();
    };

    /**
     * 初始化组件
     * @returns {boolean}
     */


    p.init = function () {



      if (initBaseFields()) {
        var sideDiv = new side1({
          //currentIndex: '2',
          cfApp: cfApp
        });
        sideDiv.init();
        log();
        loadData();
        initInfinite();
        search();
        event();
         $('.language').click(function () {
           if(!p.english){
 location.href = 'exhibi-material-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1';
           }else{
 location.href = 'exhibi-material.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
           }
         
        });
        return true;
      } else {
        return false;
      }
    };
    var log = function () {
      var formdata = {
        openid: p.empInfo.openId,
        module: "展会",
        modulename: "展品信息",
        keyword: "展品信息",
        keywordid: '',
        vt: new Date().getTime(),
        appid: cfApp.getQueryString('appid'),
        url: location.href
      };
      G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


      });
    }

    var loadData = function () {
        if(p.english){
            $.showLoading("Loading");
        }else{
            $.showLoading();
        }

      var formdata = {
        exhibi_id: cfApp.getQueryString('id'),
        page: p.page,
        pagesize: 10,
        memberUid: p.empInfo.memberId,
        accountsId: p.empInfo.accountsId,
        sample_title:p.sample_title,
          type:cfApp.getQueryString('english')
      };
      G.ajax('get', p.params.dataApi, formdata, function (retdata) {
        $.hideLoading();
        if (retdata.errorNo == '0') {
          var content = $('#list-template').html();
          p.template = Handlebars.compile(content);
          var htmlStr = p.template(retdata);
          $('#list').append(htmlStr);


          if (retdata.data.length < 10) {
            $('.weui-loadmore').remove();
            p.loading = true;
          } else {
            p.page++;
            p.loading = false;
          }
        }else{
            $('.weui-loadmore').remove();
        }

      });


    }

    var initInfinite = function () {
      $('body').infinite().on("infinite", function () {
        if (p.loading) return;
        p.loading = true;

        setTimeout(function () {

          loadData();

        }, 800);
      });
    };


    var search=function(){
     //
    $('#search').on('search', function () {
        var obj = $(this);
        p.sample_title = obj.val();
        p.page=0;
        //
        $('#list').html("");
        loadData();
        document.activeElement.blur();//软键盘收起
    });

    }
    var event = function () {
        $('#list').on('click', 'li', function () {
          var id = $(this).attr('id');

          if(p.english){
location.href = 'exhibi-detail-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id')+'&english=1'+'&sampleId='+id;
          }else{
location.href = 'exhibi-detail.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id')+"&sampleId="+id;
          }
          
        })
      }


  };

  return MeetingMaterial;
})();