package com.cftech.workshop.workshop.service.impl;

import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Sort;
import com.cftech.workshop.workshop.model.WorkShopMessageDto;
import com.cftech.workshop.workshop.model.Workshop;
import com.cftech.workshop.workshop.dao.WorkshopMapper;
import com.cftech.workshop.workshop.model.WorkshopDto;
import com.cftech.workshop.workshop.model.WorkshopRSVP;
import com.cftech.workshop.workshop.service.WorkshopService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.sql.SQLClientInfoException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author byj
 * @date: 2018-06-22 17:30
 */
@Service("workshopService")
public class WorkshopServiceImpl extends GenericServiceImpl<Workshop> implements WorkshopService {



    @Autowired
    @Qualifier("workshopMapper")
    private WorkshopMapper workshopMapper;

    @Override
    public GenericDao<Workshop> getGenericMapper() {
        return workshopMapper;
    }

    @Override
    public List<WorkshopDto> searchmembershop(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return workshopMapper.searchmembershop(params);
    };

    @Override
    public List<WorkshopDto> delworkshop(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return workshopMapper.delworkshop(params);
    };


    @Override
    public int delnum(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return workshopMapper.delnum(params);
    }

    @Override
    public List<WorkshopRSVP> exportRSVP(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return workshopMapper.exportRSVP(params);
    }

    @Override
    public List<WorkShopMessageDto> getTemplateWorkShopMessage(Conds conds) {
        Map<String,Object> para = new HashMap<String,Object>();
        para.put("conds",conds);
        return workshopMapper.getTemplateWorkShopMessage(para);
    }


    @Override
    public List<Workshop> selectworkshop(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return  workshopMapper.selectworkshop(params);
    }

    /**
     * 参加研讨会
     * @param member_uid 会员UID
     */
    @Override
    public List<WorkshopDto>   joinmeeting(String member_uid,String invitecode){
       Conds conds = new Conds();
        conds.equal("w.invitcode",invitecode);
        conds.equal("w.del_flag",0);
        Sort sort = new Sort("w.create_time", OrderType.DESC);
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("sort", sort);
        List<WorkshopDto> list = workshopMapper.searchmembershop(params);
            if (list!=null && list.size()>0){
                Workshop workshop = new Workshop();
                workshop.setId(list.get(0).getId());
                workshop.setStatus("1");
                workshop.setMember_uid(member_uid);
                workshopMapper.update(workshop);
            }
            return  workshopMapper.searchmembershop(params);
    }

}