package com.cftech.workshop.screen.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.workshop.screen.model.Screen;
import com.cftech.workshop.screen.dao.ScreenMapper;
import com.cftech.workshop.screen.model.ScreenDto;
import com.cftech.workshop.screen.model.ScreenTopic;
import com.cftech.workshop.screen.service.ScreenService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author byj
 * @date: 2018-10-22 15:41
 */
@Service("screenService")
public class ScreenServiceImpl extends GenericServiceImpl<Screen> implements ScreenService {

    @Autowired
    @Qualifier("screenMapper")
    private ScreenMapper screenMapper;

    @Override
    public GenericDao<Screen> getGenericMapper() {
        return screenMapper;
    }

    @Override
    public List<ScreenTopic> selectscreentopic(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return screenMapper.selectscreentopic(params);
    }

    @Override
    public int countscreentopic(Conds conds){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return screenMapper.countscreentopic(params);
    };

    @Override
    public Screen selectbyconds(Conds conds){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return screenMapper.selectbyconds(params);
    };

    @Override
    public ScreenDto selectquestion(Conds conds){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return screenMapper.selectquestion(params);
    };

}