package com.cftech.common.use.service.impl;

import com.cftech.common.appitems.dao.AppitemsMapper;
import com.cftech.common.appitems.model.Appitems;
import com.cftech.common.promotionstock.dao.PromotionStockMapper;
import com.cftech.common.promotionstock.model.PromotionStock;
import com.cftech.common.send.util.CommonWorkFlowConstants;
import com.cftech.common.use.model.Use;
import com.cftech.common.use.dao.UseMapper;
import com.cftech.common.use.service.UseService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 通用申请单部门ServiceImpl
 *
 * @author faye
 * @date: 2019-08-14 17:08
 */
@Service("useService")
public class UseServiceImpl extends GenericServiceImpl<Use> implements UseService {

    @Autowired
    @Qualifier("useMapper")
    private UseMapper useMapper;

    @Autowired
    private AppitemsMapper appitemsMapper;

    @Autowired
    private PromotionStockMapper promotionStockMapper;

    @Override
    public int insertItemByUse(Appitems appitems, String[] useIds) {
        Integer stock = 0;
        Integer disStock = 0;
        if(StringUtils.isNotBlank(appitems.getAuthenticStock())){
            stock = Integer.valueOf(appitems.getAuthenticStock());
        }
        if(appitems.getDisStock()!=null){
            disStock = appitems.getDisStock();
        }
       if(appitems.getId()==null){
           appitemsMapper.save(appitems);
           //增加管理员库存明细
           if(stock>0){
               promotionStockMapper.save(initPromotionStock(0,stock, CommonWorkFlowConstants.PROMOTION_STOCK_MANAGER_TYPE,appitems.getCreateBy(),appitems.getId()));
           }
           //增加供应商库存明细
           if(disStock>0){
               promotionStockMapper.save(initPromotionStock(0,disStock, CommonWorkFlowConstants.PROMOTION_STOCK_DIS_TYPE,appitems.getCreateBy(),appitems.getId()));
           }
       }else{
           //更改时查询原有库存
           Appitems oldAppitems = appitemsMapper.fetchById(appitems.getId());
           Integer oldStock = Integer.valueOf(oldAppitems.getAuthenticStock());
           Integer oldDisStock = oldAppitems.getDisStock();
           if(!oldStock.equals(stock)){//库存做了改变
               promotionStockMapper.save(initPromotionStock(oldStock,stock, CommonWorkFlowConstants.PROMOTION_STOCK_MANAGER_TYPE,appitems.getCreateBy(),appitems.getId()));
           }
           if(!oldDisStock.equals(disStock)){
               promotionStockMapper.save(initPromotionStock(oldDisStock,disStock,CommonWorkFlowConstants.PROMOTION_STOCK_DIS_TYPE,appitems.getCreateBy(),appitems.getId()));
           }
           appitemsMapper.update(appitems);
       }
       if(useIds!=null && useIds.length>0){
           useMapper.deleteItemByUse(appitems.getId());
           Map<String, Object> params = new HashMap<String, Object>();
           params.put("id",appitems.getId());
           params.put("useIds",useIds);
           return useMapper.insertItemByUse(params);
       }
       return 1;
    }

    private PromotionStock initPromotionStock(Integer oldStock,Integer stock,Integer type,Long createBy,Long itemId){
        PromotionStock promotionStock = new PromotionStock();
        promotionStock.setChangeNum(oldStock.equals(0)?stock:(stock-oldStock));
        promotionStock.setCreateBy(createBy);
        promotionStock.setItemId(itemId);
        promotionStock.setType(type);
        promotionStock.setAfterChangeStock(stock);
        promotionStock.setStatus(0);//后台手工调整
        return promotionStock;
    }

    @Override
    public List<Use> fetchSearchByPageItemByUse(Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return useMapper.fetchSearchByPageItemByUse(params);
    }

    @Override
    public GenericDao<Use> getGenericMapper() {
        return useMapper;
    }

}
