package com.cftech.cms.specialarticle.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * CMS专题文章管理
 *
 * @author lisw
 * @date: 2017-05-04 10:03
 */
@Data
public class SpecialArticle implements Serializable {

    /* 主键id */
    private Long id;
    /* 专题ID */
    @ExportConfig(value = "专题ID", width = 100)
    private Long special_id;
    /* 文章ID */
    @ExportConfig(value = "文章ID", width = 100)
    private Long article_id;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public SpecialArticle() {
        this.delFlag = false;
        this.status = "0";
    }

}