package com.cftech.core.util;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

/**
 * 移动端登录实体
 * Created by Jasper Huang on 2018/6/5.
 */
@Data
public class WxLoginEntity {
    private String accountsId;//服务号账户ID
    private String province;//粉丝所在省份
    private String city;//粉丝所在城市
    private String nickname;//粉丝NICK NAME
    private String imageUrl;//粉丝头像
    private String memberUid;//会员唯一ID
    private String openId;//粉丝OPENID
    private String timestamp;
    private String requestuid; //校验是否是请求的发起者ID

    public WxLoginEntity(String accountsId, Object nickname, Object imageUrl, Object memberUid, Object openId)
    {
        this.accountsId = accountsId;
        this.nickname = (nickname==null?"":nickname.toString());
        this.imageUrl = (imageUrl==null?"":imageUrl.toString());
        this.memberUid = (memberUid==null?"":memberUid.toString());
        this.openId =  (openId==null?"":openId.toString());
    }

    public Map<String,Object> claims()
    {
        Map<String,Object> claims = new HashMap<String,Object>();
        claims.put("accountsId",getAccountsId());
        claims.put("nickname",getNickname());
        claims.put("imageUrl",getImageUrl());
        claims.put("memberUid",getMemberUid());
        claims.put("openId",getOpenId());
        return claims;
    }

    public String subject()
    {
        JSONObject obj = new JSONObject();
        obj.put("openId",getOpenId());
        obj.put("memberUid",getMemberUid());
        return obj.toJSONString();
    }


}
