package com.cftech.productintowareroom.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 产品入库单
 *
 * @author Buyj
 * @date: 2020-09-27 17:38
 */
@Data
public class ProductIntoWareroom implements Serializable {

    /* 主键id */
    private Long id;
    /* 入库编码 */
    @ExportConfig(value = "入库编码", width = 150, showLevel = 1)
    private String intoWareroomNumber;
    /* 出库编码 */
    private String outWareroomNumber;
    /* 商品SKU码 */
    @ExportConfig(value = "商品SKU码", width = 150, showLevel = 1)
    private String productSkuNumber;
    /* 商品编码 */
    @ExportConfig(value = "商品编码", width = 150, showLevel = 1)
    private String productNumber;
    /* 商品名称 */
    @ExportConfig(value = "商品名称", width = 150, showLevel = 1)
    private String productName;
    /* 商品数量 */
    @ExportConfig(value = "商品数量", width = 150, showLevel = 1)
    private Long productAmount;
    /**
     * 商品分类编码
     */
    @ExportConfig(value = "商品分类编码", width = 150, showLevel = 1)
    private String productClassifyNumber;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public ProductIntoWareroom() {
        this.delFlag = false;
        this.status = "0";
    }

}