package com.cftech.productclassify.service;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.productclassify.model.Productclassify;
import com.cftech.core.generic.GenericService;

import java.util.List;
import java.util.Map;

/**
* 产品分类Service
*
* @author Buyj
* @date: 2020-09-22 18:06
*/
public interface ProductclassifyService extends GenericService<Productclassify> {

    /**
     * 查找产品分类
     * @param conds
     * @param sort
     * @param pageNo
     * @param pageSize
     * @return
     */
    List<Productclassify> fetchTreeByPage(Conds conds , Sort sort,int pageNo , int pageSize);
    /**
     *
     * @Description  商品列表展示
     * @Date 15:16 2020/10/21
     * @Param
     * @return
     **/
    JSONObject productList(String productName, String classifyName, String dosagaFrom);
    /**
     *
     * @Description  商品分类菜单数据回填
     * @Date 15:16 2020/10/21
     * @Param
     * @return
     **/
    JSONObject productMenu();

    /**
     * 根据分类编码查分类ID
     * @param classifyNumber
     * @return
     */
    String selectIdsByNumber(String classifyNumber);

}
