package com.cftech.productclassify.dao;

import com.cftech.productclassify.model.ProductMenuVO;
import com.cftech.productclassify.model.Productclassify;
import com.cftech.core.generic.GenericDao;
import com.cftech.productclassify.model.ProductclassifyVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
* 产品分类Mapper
*
* @author Buyj
* @date: 2020-09-22 18:06
*/
public interface ProductclassifyMapper extends GenericDao<Productclassify> {

    /**
     * 查产品分类
     * @param params
     * @return
     */
    List<Productclassify> fetchTreeByPage(Map<String, Object> params);
    /**
     *
     * @Description 商品列表展示
     * @Date 15:19 2020/10/21
     * @Param
     * @return
     **/
    List<ProductclassifyVO> productList(@Param("productName") String productName, @Param("classifyName") String classifyName, @Param("dosagaFrom") String dosagaFrom);
    /**
     *
     * @Description 商品分类菜单数据回填
     * @Date 15:19 2020/10/21
     * @Param
     * @return
     **/
    List<ProductMenuVO> productMenu();

    /**
     * 根据分类编码查分类ID
     * @param classifyNumber
     * @return
     */
    String selectIdsByNumber(String classifyNumber);
}