package com.cftech.order.dao;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.order.model.*;
import com.cftech.core.generic.GenericDao;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
* 订单管理Mapper
*
* @author Licc
* @date: 2020-10-10 14:20
*/
public interface OrderMapper extends GenericDao<Order> {
    Integer deleteAll(@Param("id") Long id);

    List<ProductOrder> listProduct();
    OrderFromVO fetchId(Serializable id);
    List<OrderFromVO> fetchProductId(Serializable id);
    ProductDto fetchProduct(Map<String,Object> params);
    Integer saveDetill(OrderDetailDto orderDetailDto);
    Integer fetcheDeta(Map<String, Object> params);
    Integer updateDetill(Map<String, Object> params);
    Order fetchOrder(Long id);
    Integer updateOrder(Map<String, Object> params);

    /**
     * @Author Licc
     * @Description  查询所有订单信息
     * @Date 15:45 2020/10/30
     * @Param
     * @return
     **/
    List<OrderMobile> orderFall(@Param("openid") String openid, @Param("status")Long status, @Param("id")Long id);
    /**
     * @Author Licc
     * @Description 根据订单ID查询订单详情
     * @Date 10:46 2020/11/1
     * @Param
     * @return
     **/
    List<ProductMobile> orderDetill(@Param("orderId")Long orderId);
}