package com.cftech.orderdetail.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.orderdetail.model.OrderDetails;
import com.cftech.orderdetail.dao.OrderDetailsMapper;
import com.cftech.orderdetail.service.OrderDetailsService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* 订单管理ServiceImpl
*
* @author Licc
* @date: 2020-10-16 11:26
*/
@Service("orderDetailsService")
public class OrderDetailsServiceImpl extends GenericServiceImpl<OrderDetails> implements OrderDetailsService {

@Autowired
@Qualifier("orderDetailsMapper")
private OrderDetailsMapper orderDetailsMapper;

@Override
public GenericDao<OrderDetails> getGenericMapper() {
return orderDetailsMapper;
}

    @Override
    public List<OrderDetails> fetchSearchByPageByUser(String userId, Conds conds, Sort sort, int page, int pageSize,Long id) {
        Map<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.equals(userId, "1")) {
            params.put("userId", userId);
        }
        params.put("id", id);
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return getGenericMapper().fetchSearchByPage(params);
    }
}