package com.cftech.sys.dao;

import com.cftech.sys.model.Role;
import com.cftech.sys.model.RoleExample;
import com.cftech.sys.model.UserRole;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 角色Dao 接口
 **/
public interface RoleMapper{
    int countByExample(RoleExample example);

    int deleteByExample(RoleExample example);

    int deleteByPrimaryKey(Long id);

    long insert(Role record);

    long insertSelective(Role record);

    List<Role> selectByExample(RoleExample example);

    Role selectByPrimaryKey(Long id);
    
    Role getByPrimaryKey(Long id);

    int updateByExampleSelective(@Param("record") Role record, @Param("example") RoleExample example);

    int updateByExample(@Param("record") Role record, @Param("example") RoleExample example);

    int updateByPrimaryKeySelective(Role record);

    int updateByPrimaryKey(Role record);
    
    List<Role> selectAll(Map<String, Object> params);

    /**
     * 通过用户id 查询用户 拥有的角色
     * 
     * @param userId
     * @return
     */
    List<UserRole> selectRolesByUserId(Long userId);
    
    int insertRole(Role record);
    
    int deleteRolePermission(Long roleid);
    
    int insertRolePermission(Role role);
    
    int updateRole(Role role);
    
    //List<Role> getRoleByIds(String ids);
    
    /**
     * 通过用户id,公众号ID 查询拥有的角色
     *
     * @return
     */
    List<UserRole> selectRolesByUserAccountsId(Map<String, Object> params);
    /**
     * 通过公众号ID查询拥有的角色
     * 
     * @param userId
     * @return
     */
    List<UserRole> selectRolesByAccountsId(Long userId);
    
    /**
     * 通过角色编码
     * @param params
     * @return
     */
    List<Role> selectAllSign(Map<String, Object> params);
}