//import com.alibaba.fastjson.JSON;
//import com.alibaba.fastjson.JSONArray;
//import com.alibaba.fastjson.JSONObject;
//import com.cftech.core.util.DateUtils;
//import lombok.Data;
//import org.apache.poi.hssf.usermodel.HSSFFont;
//import org.apache.poi.hssf.usermodel.HSSFWorkbook;
//import org.apache.poi.hssf.util.HSSFColor;
//import org.apache.poi.ss.usermodel.Cell;
//import org.apache.poi.ss.usermodel.CellStyle;
//import org.apache.poi.ss.usermodel.IndexedColors;
//import org.apache.poi.ss.usermodel.Row;
//import org.owasp.esapi.ESAPI;
//
//import java.util.Date;
//
///**
// * @author lisw
// * @program schaeffler
// * @description 促销品报表导出工具类
// * @createDate 2020-01-17 10:07:27
// **/
//@Data
//public class StatisticalCommonExportUtil {
//
//    private CellStyle genterateCellStyle;//通用单元格样式
//
//    private CellStyle goldCellStyle;//金色填充
//
//    private CellStyle greenCellStyle;//绿色填充
//
//    private CellStyle grey25CellStyle;//灰色25填充
//
//    private HSSFWorkbook wb; //表格对象
//
//    private HSSFFont hssfFontWhite;  //白色字体
//
//    private HSSFFont blackFont; //黑色字体
//
//    private HSSFFont greenFont; //绿色字体
//
//    private short rowHeight=900; //行高
//
//    private String lineStr = "\r\n";  //换行
//
//
//   public StatisticalCommonExportUtil(HSSFWorkbook wb){
//       this.wb=wb;
//       //白色字体
//       this.hssfFontWhite = wb.createFont();
//       this.hssfFontWhite.setColor(HSSFColor.WHITE.index);
//       this.hssfFontWhite.setFontName("Calibri");
//       //黑色字体
//       this.blackFont = wb.createFont();
//       this.blackFont.setColor(HSSFColor.BLACK.index);
//       this.blackFont.setFontName("Calibri");
//       //绿色字体
//       this.greenFont = wb.createFont();
//       this.greenFont.setColor(HSSFColor.GREEN.index);
//       this.greenFont.setFontName("Calibri");
//       //样式
//       this.genterateCellStyle = genterateHeader();
//       this.goldCellStyle = rtnHeaderGold();
//       this.greenCellStyle = rtnHeadersGreen();
//       this.grey25CellStyle = rtnHeaderGREY25();
//   }
//
//   //灰色填充
//    public CellStyle rtnHeaderGREY25(){
//        CellStyle cellStyle =genterateHeader();
//        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
//        cellStyle.setFont(greenFont);
//        return cellStyle;
//    }
//
//    //金色填充
//    public CellStyle rtnHeaderGold(){
//        CellStyle cellStyle =genterateHeader();
//        cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
//        cellStyle.setFont(hssfFontWhite);
//        return cellStyle;
//    }
//
//    //绿色填充
//    public CellStyle rtnHeadersGreen(){
//        CellStyle cellStyle = genterateHeader();
//        short greenIndex = IndexedColors.GREEN.index;
//        cellStyle.setFillForegroundColor(greenIndex);
//        cellStyle.setFont(hssfFontWhite);
//        return cellStyle;
//    }
//
//    //通用样式 边框定制
//    public CellStyle genterateHeader(){
//        CellStyle cellStyle =wb.createCellStyle();
//        cellStyle.setBorderBottom(CellStyle.BORDER_THIN); // 下边框
//        cellStyle.setBorderLeft(CellStyle.BORDER_THIN);// 左边框
//        cellStyle.setBorderTop(CellStyle.BORDER_THIN);// 上边框
//        cellStyle.setBorderRight(CellStyle.BORDER_THIN);// 右边框
//        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
//        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
//        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
//        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
//        cellStyle.setFillPattern(CellStyle.SOLID_FOREGROUND);
//        cellStyle.setFont(hssfFontWhite);
//        cellStyle.setFillPattern(CellStyle.SOLID_FOREGROUND);
//        cellStyle.setAlignment(CellStyle.ALIGN_CENTER); // 水平布局：居中
//        cellStyle.setVerticalAlignment(CellStyle.VERTICAL_CENTER);
//        cellStyle.setWrapText(true);// 设置自动换行
//        cellStyle.setFont(blackFont);
//        return cellStyle;
//    }
//
//    //创建通用单元格
//    public Cell createCell(int index, Object value, Row row){
//        String v = "";
//        if(value!=null && value instanceof Date){
//            Date time = (Date)value;
//            v= DateUtils.formatDate(time,"yyyy-MM-dd HH:mm");
//        }else{
//            v=value!=null?String.valueOf(value):"";
//        }
//        Cell cell = row.createCell(index);
//        cell.setCellValue(String.valueOf(v));
//        cell.setCellStyle(getGenterateCellStyle());
//        return cell;
//    }
//
//    //解析固化ITEMS JSON数据返回String管理员发货数量
//    public String parseItemsManagerJSON(String items){
//        StringBuffer parseBuffer = new StringBuffer();
//        JSONArray array = JSON.parseArray(ESAPI.encoder().decodeForHTML(items));
//        for(int k =0;k<array.size();k++){
//            JSONObject obj = array.getJSONObject(k);
//            String name = obj.getString("name");
//            String count = obj.getString("managerGrantCount");
//            parseBuffer.append(name+"*"+count+";"+getLineStr());
//        }
//        return parseBuffer.toString();
//    }
//
//    //解析固化ITEMS JSON数据返回String供应商发货数量
//    public String parseItemsSupplierJSON(String items){
//        StringBuffer parseBuffer = new StringBuffer();
//        JSONArray array = JSON.parseArray(ESAPI.encoder().decodeForHTML(items));
//        for(int k =0;k<array.size();k++){
//            JSONObject obj = array.getJSONObject(k);
//            String name = obj.getString("name");
//            String count = obj.getString("disGrantCount");
//            parseBuffer.append(name+"*"+count+";"+getLineStr());
//        }
//        return parseBuffer.toString();
//    }
//}
