package com.cftech.common.manager.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 通用申请单管理员配置
 *
 * @author faye
 * @date: 2019-08-14 17:21
 */
@Data
public class Manager implements Serializable {

    /* 主键id */
    private Long id;
    /* 管理员OPENID */
    @ExportConfig(value = "管理员OPENID", width = 100)
    private String openid;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    private Long typeform;

    public Manager() {
        this.delFlag = false;
        this.status = "0";
    }

}