package com.cftech.membercard.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.membercard.model.McardExplain;
import com.cftech.membercard.service.McardExplainService;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String MCARDEXPLAIN_VIEW = "qy:mcardExplain:view"
 * 查看:public static final String MCARDEXPLAIN_EDIT = "qy:mcardExplain:edit"
 *
 * @author lisw
 * @date: 2017-08-30 13:16
 */
@Slf4j
@Controller
@RequestMapping("/a/mcardExplain")
public class McardExplainController {

    public static final String MCARDEXPLAIN_VIEW = "qy:mcardExplain:view";
    public static final String MCARDEXPLAIN_EDIT = "qy:mcardExplain:edit";

    @Autowired
    private McardExplainService mcardExplainService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = MCARDEXPLAIN_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "mcardExplain/mcardExplainlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = MCARDEXPLAIN_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            McardExplain mcardExplain = mcardExplainService.fetchById(id);
            model.addAttribute("data", mcardExplain);
        }
        return "mcardExplain/mcardExplainform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = MCARDEXPLAIN_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(McardExplain mcardExplain, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (mcardExplain != null && mcardExplain.getId() != null) {
                mcardExplain.setUpdateBy(UserUtils.getUser().getId());
                mcardExplainService.update(mcardExplain);
                rtnJson.put("errorNo", 0);
            } else {
                mcardExplain.setNumber(codingruleUtils.getNumber(accountsId, McardExplain.class.getName()));
                mcardExplain.setAccountsId(accountsId);
                mcardExplain.setDelFlag(false);
                mcardExplain.setAccountsId(UserUtils.getmpaccounts(request));
                mcardExplain.setCreateBy(UserUtils.getUser().getId());
                mcardExplain.setUpdateBy(UserUtils.getUser().getId());
                mcardExplainService.save(mcardExplain);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = MCARDEXPLAIN_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, McardExplain mcardExplain, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(mcardExplain.getNumber())) {
            conds.like("number", mcardExplain.getNumber());
        }
        if (!StringUtils.isEmpty(mcardExplain.getName())) {
            conds.like("name", mcardExplain.getName());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<McardExplain> list = mcardExplainService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = mcardExplainService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = MCARDEXPLAIN_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            mcardExplainService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
