package com.cftech.report.dao;

import com.cftech.report.model.Report;
import com.cftech.core.generic.GenericDao;
import com.cftech.report.model.ReportCode;
import com.cftech.report.model.ReportDoctorInfo;
import com.cftech.report.model.ReportPeopleInfo;

import java.util.List;
import java.util.Map;

/**
* 报表信息Mapper
*
* @author Buyj
* @date: 2020-12-02 11:26
*/
public interface ReportMapper extends GenericDao<Report> {

    /**
     *  查询报表人员信息
     * @param params
     * @return
     */
    List<ReportPeopleInfo> selectReportPeopleInfo(Map<String,Object> params);

    /**
     *  查询用户对应的扫码记录信息
     * @param params
     * @return
     */
    List<ReportCode> selectReportCodeInfo(Map<String,Object> params);

    /**
     * 根据医生id查询医生信息
     * @param params
     * @return
     */
    ReportDoctorInfo selectReportDoctorInfo(Map<String,Object> params);

}