package com.cftech.order.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 订单管理
 *
 * @author Licc
 * @date: 2020-10-10 14:20
 */
@Data
public class Order extends OrderDetail implements Serializable {

    /* 主键id */
    private Long id;
    /* 订单编码 */
    @ExportConfig(value = "订单编码", width = 100, showLevel = 1)
    private String number;
    /* 用户所属公众号id */
    @ExportConfig(value = "用户所属公众号id", width = 100, showLevel = 1)
    private String openid;
    /* 付款回调详情 */
    @ExportConfig(value = "付款回调详情", width = 100, showLevel = 1)
    private String payStatus;
    /* 付款金额 */
    @ExportConfig(value = "付款金额", width = 100, showLevel = 1)
    private Double payAmount;
    /* 订单金额 */
    @ExportConfig(value = "订单金额", width = 100, showLevel = 1)
    private Double orderAmount;
    /* 商品最终金额 */
    @ExportConfig(value = "商品最终金额", width = 100, showLevel = 1)
    private Double totalAmount;
    /* 付款时间 */
    @ExportConfig(value = "付款时间", width = 100, showLevel = 1)
    private Date payTime;
    /* 交易号 支付宝/第三方平台 返回订单号 */
    @ExportConfig(value = "交易号 支付宝/第三方平台 返回订单号", width = 100, showLevel = 1)
    private String tradeNo;
    /* 顺丰运单号 */
    private String courierNumber;
    /* 订单开票编码 */
    private String confirm;
    /* 订单取消原因 */
    @ExportConfig(value = "订单取消原因", width = 100, showLevel = 1)
    private String orderCancel;
    /* 卖家备注 */
    @ExportConfig(value = "remarks", width = 100, showLevel = 1)
    private String remarks;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 咨询单id */
    @ExportConfig(value = "咨询单id", width = 100, showLevel = 1)
    private Long consultId;
    /* 收货地址 */
    private Long addressId;
    /* 收货地址详情 */
    private String addressDes;
    /* 所属会员id */
    @ExportConfig(value = "所属会员id", width = 100, showLevel = 1)
    private Long memberId;
    /* 客服id */
    @ExportConfig(value = "客服id", width = 100, showLevel = 1)
    private Long serviceId;
    /* 医生id */
    @ExportConfig(value = "医生id", width = 100, showLevel = 1)
    private Long doctorId;
    /* 订单员id */
    @ExportConfig(value = "订单员id", width = 100, showLevel = 1)
    private Long clerkId;
    /* 创建时间 */
    private Date createTime;
    private String createTimeStr;
    /* 更新时间 */
    private Date updateTime;

    private Date orderTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;
    /* 产品编码 */
    private String productNumber;
    /* 产品名称 */
    private String productName;

    private Long productId;

    /**
     * 订单提醒类型
     */
    private String remindType;

    /**
     * 购方地址
     */
    private String address;

    private List<ProductVO> list;

    private Date cancelTime;

    /**
     * 规格
     */
    private String format;

    /**
     * 商品单价
     */
    private Double price;

    /**
     * 会员名称
     */
    private String memberName;

    /**
     * 会员手机
     */
    private String memberPhone;

    /**
     * 收件时间到今天是否超过七天  标识字段（0：是 1：否）
     */
    private String isExceedSevenDay;




    /**
     * 搜索字段
     */
    private String consultCode; /* 咨询单编码 */
    private String productNameTmp;//产品名称
    private String startOrderAmount;//订单开始金额
    private String endOrderAmount;//订单结束金额
    private String startPayAmount;//付款开始金额
    private String endPayAmount;//付款结束金额
    private String isBill;  /* 是否开票 0:是 1:否 */
    private String orderStartTime;//订单开始时间
    private String orderEndTime;//订单结束时间
    private String nickName;//患者昵称
    private String sendExpressDateStr;//发件时间
    private String acceptExpressDateStr;//签收时间
    private String outTime;//出库时间
    private String takeFrequency;//服用频率
    private String fansAlias;//粉丝别名



    public Order() {
        this.delFlag = false;
        this.status = "0";
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductName() {
        if (list == null) {
            return null;
        }
        List<String> collect = this.list.stream().map(x -> x.getProductName()).collect(Collectors.toList());
        return StringUtils.join(collect, ";");
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @Override
    public String getOpenid() {
        return openid;
    }

    @Override
    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }

    public Double getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(Double payAmount) {
        this.payAmount = payAmount;
    }

    public Double getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(Double orderAmount) {
        this.orderAmount = orderAmount;
    }

    public Double getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getCourierNumber() {
        return courierNumber;
    }

    public void setCourierNumber(String courierNumber) {
        this.courierNumber = courierNumber;
    }

    public String getConfirm() {
        return confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String getOrderCancel() {
        return orderCancel;
    }

    public void setOrderCancel(String orderCancel) {
        this.orderCancel = orderCancel;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    public Long getAccountsId() {
        return accountsId;
    }

    @Override
    public void setAccountsId(Long accountsId) {
        this.accountsId = accountsId;
    }

    @Override
    public boolean isDelFlag() {
        return delFlag;
    }

    @Override
    public void setDelFlag(boolean delFlag) {
        this.delFlag = delFlag;
    }

    @Override
    public String getStatus() {
        return status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    public Long getConsultId() {
        return consultId;
    }

    public void setConsultId(Long consultId) {
        this.consultId = consultId;
    }

    public Long getAddressId() {
        return addressId;
    }

    public void setAddressId(Long addressId) {
        this.addressId = addressId;
    }

    public String getAddressDes() {
        return addressDes;
    }

    public void setAddressDes(String addressDes) {
        this.addressDes = addressDes;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public Long getServiceId() {
        return serviceId;
    }

    public void setServiceId(Long serviceId) {
        this.serviceId = serviceId;
    }

    public Long getDoctorId() {
        return doctorId;
    }

    public void setDoctorId(Long doctorId) {
        this.doctorId = doctorId;
    }

    public Long getClerkId() {
        return clerkId;
    }

    public void setClerkId(Long clerkId) {
        this.clerkId = clerkId;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Long getCreateBy() {
        return createBy;
    }

    @Override
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Override
    public Long getUpdateBy() {
        return updateBy;
    }

    @Override
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String getProductNumber() {
        return productNumber;
    }

    public void setProductNumber(String productNumber) {
        this.productNumber = productNumber;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public List<ProductVO> getList() {
        return list;
    }

    public void setList(List<ProductVO> list) {
        this.list = list;
    }

    public String getConsultCode() {
        return consultCode;
    }

    public void setConsultCode(String consultCode) {
        this.consultCode = consultCode;
    }

    public String getProductNameTmp() {
        return productNameTmp;
    }

    public void setProductNameTmp(String productNameTmp) {
        this.productNameTmp = productNameTmp;
    }

    public String getStartOrderAmount() {
        return startOrderAmount;
    }

    public void setStartOrderAmount(String startOrderAmount) {
        this.startOrderAmount = startOrderAmount;
    }

    public String getEndOrderAmount() {
        return endOrderAmount;
    }

    public void setEndOrderAmount(String endOrderAmount) {
        this.endOrderAmount = endOrderAmount;
    }

    public String getStartPayAmount() {
        return startPayAmount;
    }

    public void setStartPayAmount(String startPayAmount) {
        this.startPayAmount = startPayAmount;
    }

    public String getEndPayAmount() {
        return endPayAmount;
    }

    public void setEndPayAmount(String endPayAmount) {
        this.endPayAmount = endPayAmount;
    }

    public String getIsBill() {
        return isBill;
    }

    public void setIsBill(String isBill) {
        this.isBill = isBill;
    }

    public String getOrderStartTime() {
        return orderStartTime;
    }

    public void setOrderStartTime(String orderStartTime) {
        this.orderStartTime = orderStartTime;
    }

    public String getOrderEndTime() {
        return orderEndTime;
    }

    public void setOrderEndTime(String orderEndTime) {
        this.orderEndTime = orderEndTime;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public Date getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    public String getSendExpressDateStr() {
        return sendExpressDateStr;
    }

    public void setSendExpressDateStr(String sendExpressDateStr) {
        this.sendExpressDateStr = sendExpressDateStr;
    }

    public String getAcceptExpressDateStr() {
        return acceptExpressDateStr;
    }

    public void setAcceptExpressDateStr(String acceptExpressDateStr) {
        this.acceptExpressDateStr = acceptExpressDateStr;
    }

    public Date getCancelTime() {
        return cancelTime;
    }

    public void setCancelTime(Date cancelTime) {
        this.cancelTime = cancelTime;
    }
}