package com.cftech.workshop.meeting.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.workshop.meeting.model.Meeting;
import com.cftech.workshop.meeting.service.MeetingService;
import com.cftech.workshop.workshop.model.Workshop;
import com.cftech.workshop.workshop.model.WorkshopDto;
import com.cftech.workshop.workshop.service.WorkshopService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;

import java.util.List;

/**
 * y研讨会接口
 * Created by byj on 2018/7/11.
 */
@RestController
@RequestMapping(value = "/mobile/auth/meeting")
public class MobileMeetingController {
    @Autowired
    private MeetingService meetingService;

    @Autowired
    private WorkshopService workshopService;

    /**
     * 获得签到二维码
     * @param meetingId 研讨会ID
     * @return
     */
    @RequestMapping(value = "/getqrcode", method = {RequestMethod.POST,RequestMethod.GET} , produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getqrcode(Long meetingId,String member_uid){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(String.valueOf(meetingId))){
                Meeting meeting = meetingService.fetchById(meetingId);
                if(meeting!=null){
                    jsonObject.put("errorNo",0);
                    jsonObject.put("title",meeting.getTitle());
                    jsonObject.put("titleEn",meeting.getTitleEn());
                    jsonObject.put("cover",meeting.getCover());
                }
                Conds wConds = new Conds();
                wConds.equal("w.member_uid",member_uid);
                wConds.equal("w.wsid",meetingId);
                Workshop workshop =workshopService.fetchSearchByConds(wConds);
                jsonObject.put("qrCode",workshop.getInvitcode());
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

    /**
     * 二维码签到
     * @param member_uid 会员Uid
     * @return
     */
    @RequestMapping(value = "/getqiandao", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject getqiandao(String member_uid){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(member_uid)){
                Conds conds = new Conds();
                conds.equal("w.member_uid",member_uid);
                conds.equal("w.del_flag",0);
                Sort sort = new Sort("w.create_time", OrderType.DESC);
                List<Workshop> list = workshopService.fetchSearchByPage(conds,sort,0,0);
                if(list.size()>0 && list != null){
                    for (Workshop workshop : list){
                        workshop.setStatus("2");
                        workshopService.update(workshop);
                        jsonObject.put("errorNo",0);
                    }
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }

    /**
     * 判断是否注册
     * @param memberUid 会员Uid
     * @return
     */
   /* @RequestMapping(value = "/isregis")
    public JSONObject isregis(String memberUid){
        JSONObject jsonObject = new JSONObject();
        try {
            if(StringUtils.isNoneBlank(memberUid)){
                Conds conds = new Conds();
                conds.equal("w.member_uid",memberUid);
                Sort sort = new Sort("create_time",OrderType.DESC);
                List<Workshop> list = workshopService.fetchSearchByPage(conds,sort,0,0);
                if(list.size()>0){
                    jsonObject.put("errorNo",0);//已注册
                }else{
                    jsonObject.put("errorNo",2); //未注册
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return jsonObject;
    }*/
}
