package com.cftech.showroom.appform.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.showroom.appform.dao.ShowroomEvaluateMapper;
import com.cftech.showroom.appform.model.ShowroomEvaluate;
import com.cftech.showroom.appform.model.ShowroomEvaluateVo;
import com.cftech.showroom.appform.service.ShowroomEvaluateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @version V1.0
 * @Package com.cftech.showroom.appform.service.impl
 * @Name cftech-platform
 * @Description: TODO (用一句话描述该文件做什么)
 * @date 2020/6/29
 */
@Service("showroomEvaluateService")
public class ShowroomEvaluateServiceImpl extends GenericServiceImpl<ShowroomEvaluate> implements ShowroomEvaluateService {

    @Autowired
    @Qualifier("showroomEvaluateMapper")
    private ShowroomEvaluateMapper showroomEvaluateMapper;

    @Override
    protected GenericDao<ShowroomEvaluate> getGenericMapper() {
        return showroomEvaluateMapper;
    }

    @Override
    public ShowroomEvaluateVo sumStartNum(Conds var1,String beginTime, String endTime) {
        Map<String, Object> params = new HashMap();
        params.put("conds", var1);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        return showroomEvaluateMapper.sumStartNum(params);
    }

    @Override
    public Integer countEvaluate(Conds var1, String beginTime, String endTime) {
        Map<String, Object> params = new HashMap();
        params.put("conds", var1);
        params.put("beginTime", beginTime);
        params.put("endTime", endTime);
        return showroomEvaluateMapper.countEvaluate(params);
    }
}
