package com.cftech.mp.wechat.model;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * wx_mp_imagetext 实体类
 * Created by lisw 25/10/2016.
 */ 
@Data
@NoArgsConstructor
public class NewsMedia implements Serializable {
	/**
	 * id
	 */
	private Long id;

	/**
	 * 作者
	 */
	private String author;

	/**
	 * 阅读全文链接
	 */
	private String readDetail;

	/**
	 * 标题
	 */
	private String title;

	/**
	 * 描述
	 */
	private String description;


	/**
	 * 创建时间
	 */
	private Timestamp createtime;

	/**
	 * 修改时间
	 */
	private Timestamp updatetime;

	/**
	 * 创建人
	 */
	private Long createBy;

	/**
	 * 修改人
	 */
	private Long updateBy;

	/**
	 * 删除标识
	 */
	private String delflag;

	/**
	 * 图文详情
	 */
	private String content;

	/**
	 * 公众号ID
	 */
	private Long accountsid;
	
	
	/**
	 *是否在详情内显示封面图  0：不显示  1：显示'
	 */
	private String showCoverPic;
	
	/**
	 * 图片是否上传到微信官方，成为微信素材 0:不上传   1：上传
	 */
	private String isThumbMedia;
	 
	/**
	 * 缩略图上传到微信官方的media_id
	 */
	private String thumbMediaId;
	
	/**
	 * 缩略图上传到微信官方的url,此URL仅仅能在微信中使用，所以需上传到本地一份
	 */
	private String uploadimgUrl;
	
	/**
	 * 本地服务器封面图的URL
	 */
	private String picUrl;
	

}