package com.cftech.like.service;

import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.like.model.Like;
import com.cftech.like.model.LikeDto;

import java.util.List;

/**
 * likeService
 * Created by mubo 11/05/2017.
 */
public interface LikeService extends GenericService<Like> {
    /**
     * 点赞
     * */
    Boolean saveLike(Like like);
    /**
     * 取消收藏
     * */
    Boolean clearLike(Like like);
    /**
     * 获取收藏数
     * */
    Integer getLikeCount(Conds conds);
    /**
     * 获取收藏列表数据eqrweqw2ewqweqewq2ewqS cvb
     * */
    List<LikeDto> findLikeByPage(Conds conds, Sort sort, int iDisplayStart, int iDisplayLength);
    /**
     * 获取收藏列表数据总数
     * */
    Integer findLikeCount(Conds conds);

    /**
     * 修改某模块下面的点赞量
     * @param like
     */
    void saveModulLike (Like like);
}
