package com.cftech.sys.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.sys.dao.UserMapper;
import com.cftech.sys.model.User;
import com.cftech.sys.model.UserAuth;
import com.cftech.sys.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * userService
 * Created by lisw 25/09/2016.
 */
@Service()
public class UserServiceImpl extends GenericServiceImpl<User> implements UserService {

	/**
	 * userMapper
	 */
	@Autowired
	@Qualifier("userMapper")
	private UserMapper userMapper;

	@Override
	public GenericDao<User> getGenericMapper() {
		return userMapper;
	}

	@Override
	public int clearUserRole(Long userId) {
		return userMapper.clearUserRole(userId);
	}

	@Override
	public int saveBatchRole(Long userId,Long roleId,Long accountId) {
		Map<String,Object> params = new HashMap<String, Object>();
		params.put("userId",userId);
		params.put("roleId",roleId);
		params.put("accountId",accountId);
		return userMapper.saveBatchRole(params);
	}

	@Override
	public User fetchStoreUserById(Long id) {
		return userMapper.fetchStoreUserById(id);
	}

	@Override
	public User fetchByQyuserId(Long qyUserId) {
		return userMapper.fetchByQyuserId(qyUserId);
	}

	@Override
	public UserAuth fetchAuthById(Serializable id)
	{
		return userMapper.fetchAuthById(id);
	}

	@Override
	public List<User> fetchoruserBycond(Conds conds, Long id){
		Map<String,Object> params = new HashMap<String, Object>();
		params.put("conds", conds);
		params.put("id", id);
		return  userMapper.fetchoruserBycond(params);
	};
}
