package com.cftech.brand.job;

import com.cftech.accounts.model.SysJob;
import com.cftech.accounts.service.JobService;
import com.cftech.brand.apply.model.BrandApply;
import com.cftech.brand.apply.service.BrandApplyService;
import com.cftech.brand.manager.model.BrandManager;
import com.cftech.brand.manager.service.BrandManagerService;
import com.cftech.brand.util.BrandApplyTempMsgUtil;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.*;
import lombok.extern.slf4j.Slf4j;
import org.mp.api.wxsendmsg.JwTemplateMessageAPI;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 品牌申请job管理
 * @author faye
 * @date 2020-02-10
 */
@Slf4j
public class BrandApplyJob implements Job{

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        boolean isCluster = Boolean.valueOf(SystemConfig.p.getProperty("quartz.isCluster"));
        if (!isCluster) {
            return;
        }
        log.info("品牌申请交付日期提醒：启动任务=======================");
        //获得明细数据
        JobDataMap jobInfo = context.getJobDetail().getJobDataMap();
        String id = jobInfo.get("uid") == null ? "" : jobInfo.getString("uid");//这个也是ID主键
        log.info("任务ID：" + id);

        BrandManagerService brandManagerService= SpringContextHolder.getBean(BrandManagerService.class);
        BrandApplyService brandApplyService=SpringContextHolder.getBean(BrandApplyService.class);
        MpTokenUtil tokenUtil=SpringContextHolder.getBean(MpTokenUtil.class);
        Conds managerConds=new Conds();
        managerConds.equal("del_flag","0");
        List<BrandManager> brandManagers=brandManagerService.fetchSearchByPage(managerConds,null,0,0);
        Conds conds=new Conds();
        conds.equal("del_flag","0");
        conds.equal("status","3");
        conds.equal("intended_delivery_date", DateFormatUtils.getDateFormat(new Date()));
        Sort sort=new Sort("create_time", OrderType.ASC);
        List<BrandApply> datas=brandApplyService.fetchSearchByPage(conds,sort,0,0);
        for(BrandApply data:datas){
            for(BrandManager brandManager:brandManagers){
                BrandApplyTempMsgUtil.sendTemplateMsgByIntendedDeliveryDate(brandManager, data,tokenUtil.getToken(brandManager.getAccountsId()));
            }
        }
        //执行更新操作
        if (context.getNextFireTime() != null) {
            log.info("品牌申请交付日期提醒：下次执行时间=====" +
                    new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
                            .format(context.getNextFireTime()) + "==============");
        } else {
            JobService jobService = SpringContextHolder
                    .getBean(JobService.class);
            SysJob sysJob = new SysJob();

            sysJob.setJobuid(id);
            sysJob.setStatus("0");
            jobService.updateStatus(sysJob);
            log.info("品牌申请交付日期提醒一次性，已执行完成");
        }
    }
}
