package com.cftech.brand.department.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.brand.department.model.BrandDepartment;
import com.cftech.brand.department.service.BrandDepartmentService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 部门Controller
 *
 * 权限字符串说明:
 * 查看:public static final String BRANDDEPARTMENT_VIEW = "qy:brandDepartment:view"
 * 查看:public static final String BRANDDEPARTMENT_EDIT = "qy:brandDepartment:edit"
 *
 * @author faye
 * @date 2020/01/14
 */
@Slf4j
@Controller
@RequestMapping("/a/brandDepartment")
public class BrandDepartmentController {

    public static final String BRANDDEPARTMENT_VIEW = "qy:brandDepartment:view";
    public static final String BRANDDEPARTMENT_EDIT = "qy:brandDepartment:edit";

    @Autowired
    private BrandDepartmentService brandDepartmentService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    /**
     * 列表页面
     *
     * @param request
     * @param model
     * @return
     */
    @RequiresPermissions(value = BRANDDEPARTMENT_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "brandDepartment/brandDepartmentlist";
    }

    /**
     * 编辑页面（新增、修改）
     *
     * @param request
     * @param id
     * @param model
     * @return
     */
    @RequiresPermissions(value = BRANDDEPARTMENT_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            BrandDepartment brandDepartment = brandDepartmentService.fetchById(id);
            model.addAttribute("data", brandDepartment);
        }
        return "brandDepartment/brandDepartmentform";
    }

    /**
     * 提交数据（新增、修改）
     *
     * @param brandDepartment
     * @param model
     * @param request
     * @return
     */
    @RequiresPermissions(value = BRANDDEPARTMENT_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(BrandDepartment brandDepartment, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            brandDepartment.setUpdateBy(UserUtils.getUser().getId());
            if (brandDepartment != null && brandDepartment.getId() != null) {
                brandDepartmentService.update(brandDepartment);
                rtnJson.put("errorNo", 0);
            } else {
                brandDepartment.setNumber(codingruleUtils.getNumber(accountsId, BrandDepartment.class.getName()));
                brandDepartment.setAccountsId(accountsId);
                brandDepartment.setDelFlag(false);
                brandDepartment.setAccountsId(UserUtils.getmpaccounts(request));
                brandDepartment.setCreateBy(UserUtils.getUser().getId());
                brandDepartmentService.save(brandDepartment);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            log.error("保存部门异常:"+e.getMessage());
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    /**
     * 获取列表数据
     *
     * @param iDisplayStart
     * @param iDisplayLength
     * @param brandDepartment
     * @param request
     * @return
     */

    @RequiresPermissions(value = BRANDDEPARTMENT_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, BrandDepartment brandDepartment, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(brandDepartment.getNumber())) {
            conds.like("number", brandDepartment.getNumber());
        }
        if (!StringUtils.isEmpty(brandDepartment.getName())) {
            conds.like("name", brandDepartment.getName());
        }
        Sort sort = new Sort("number", OrderType.ASC);

        List<BrandDepartment> list = brandDepartmentService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = brandDepartmentService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    /**
     * 删除数据
     *
     * @param id
     * @return
     */
    @RequiresPermissions(value = BRANDDEPARTMENT_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            brandDepartmentService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    /**
     * 导出
     *
     * @param request
     * @param response
     */
    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = BRANDDEPARTMENT_VIEW)
    public void exportExcel(HttpServletRequest request,BrandDepartment brandDepartment, HttpServletResponse response) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("number", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        if (!StringUtils.isEmpty(brandDepartment.getNumber())) {
            conds.like("number", brandDepartment.getNumber());
        }
        List<BrandDepartment> list = brandDepartmentService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(BrandDepartment.class, response).toExcel(list, "部门信息");
    }

    /**
     * 模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = BRANDDEPARTMENT_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(BrandDepartment.class, response).toExcel(null, "部门信息");
    }

    /**
     * 导入
     *
     * @param request
     * @param file
     * @param model
     * @return
     */
    @RequestMapping("/importExcel")
    @RequiresPermissions(value = BRANDDEPARTMENT_EDIT)
    @ResponseBody
    public JSONObject importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        JSONObject retJson = new JSONObject();
        retJson.put("errorNo", "1");
        if (file == null) {
            retJson.put("errorMsg", "未选择导入文件");
            return retJson;
        }
        // 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().setEmptyCellValue("").readExcel(storeFile, rowData -> {
                BrandDepartment brandDepartment = new BrandDepartment();
                brandDepartment.setAccountsId(accountId);
                brandDepartment.setName(rowData.get(1));
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    brandDepartment.setNumber(rowData.get(0));
                    Conds conds=new Conds();
                    conds.equal("del_flag","0");
                    conds.equal("number",brandDepartment.getNumber());
                    BrandDepartment oldData=brandDepartmentService.fetchSearchByConds(conds);
                    if(oldData!=null){
                        brandDepartment.setId(oldData.getId());
                        brandDepartmentService.update(brandDepartment);
                    }else{
                        brandDepartment.setCreateBy(UserUtils.getUser().getId());
                        brandDepartmentService.save(brandDepartment);
                    }
                }else{
                    brandDepartment.setNumber(codingruleUtils.getNumber(accountId,BrandDepartment.class.getName()));
                    brandDepartment.setCreateBy(UserUtils.getUser().getId());
                    brandDepartmentService.save(brandDepartment);
                }
            });
            retJson.put("errorNo", "0");
            retJson.put("errorMsg", "导入成功");
        } catch (Exception e) {
            log.error(e.getMessage());
            retJson.put("errorMsg", "导入失败:" + e.getMessage());
        }

        return retJson;
    }

}
