package com.cftech.member.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.member.model.MemberVO;
import com.cftech.member.service.MemberService;
import com.sun.xml.bind.v2.model.core.ID;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * @author ：licc
 * @date ：Created in 2020/10/19 14:16
 * @description： 个人信息修改
 */
@Slf4j
@RestController
@RequestMapping("mobile/auth/member")
public class MobileMemberController {

    @Autowired
    private MemberService memberService;

    /**
     * @return
     * @Author Licc
     * @Description 个人信息数据回填
     * @Date 14:27 2020/10/19
     * @Param
     **/
    @RequestMapping(value = "/memberFormation", method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject memberFormation(String openid, String appId) {
        return memberService.memberFormation(openid, appId);
    }

    /**
     * @return
     * @Author Licc
     * @Description 个人信息修改
     * @Date 14:27 2020/10/19
     * @Param
     **/
    @RequestMapping(value = "/updateMember", method = {RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject updateMember(MemberVO memberVO) {
        return memberService.updateMember(memberVO);
    }
    /**
     * @Author Licc
     * @Description  个人中心用户信息
     * @Date 19:36 2020/11/4
     * @Param  
     * @return 
     **/
    @RequestMapping(value = "/fanssChat", method = {RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject fanssChat(String openid,String appId){
        return memberService.fanssChat(openid, appId);
    }
}
