package com.cftech.member.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.member.dao.MemberCarsMapper;
import com.cftech.member.model.MemberCars;
import com.cftech.member.service.MemberCarsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author lisw
 * @date: 2017-08-29 13:36
 */
@Service("memberCarsService")
public class MemberCarsServiceImpl extends GenericServiceImpl<MemberCars> implements MemberCarsService {

    @Autowired
    @Qualifier("memberCarsMapper")
    private MemberCarsMapper memberCarsMapper;

    @Override
    public GenericDao<MemberCars> getGenericMapper() {
        return memberCarsMapper;
    }

    @Override
    public int countPlateNumber(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return memberCarsMapper.countPlateNumber(params);
    }

    @Override
    public int updateMemberId(Long id) {
        return memberCarsMapper.updateMemberId(id);
    }
}