package com.cftech.collection.service;

import com.cftech.collection.model.Collection;
import com.cftech.collection.model.CollectionDto;
import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;

import java.util.List;

/**
 * collectionService
 * Created by mubo 11/05/2017.
 */
public interface CollectionService extends GenericService<Collection> {
    /**
     * 收藏
     * */
    Boolean saveCollection(Collection collection);
    /**
     * 取消收藏
     * */
    Boolean clearCollection(Collection collection);

    /**
     * 获取收藏数
     * */
    Integer getCollectionCount(Conds conds);
    /**
     * */
    Integer findCollectionByPageVoCount(Conds conds,String entityName);
    /**
     * 获取收藏列表数据
     * */
    List<CollectionDto> findCollectionByPageVo(Conds conds, Sort sort, int iDisplayStart, int iDisplayLength,String entityName,String userName);

    List<CollectionDto> findCollectionByPageVoCar(Conds conds, Sort sort, int iDisplayStart, int iDisplayLength);

    List<CollectionDto> findCollectionByPageVoCfarticle(Conds conds, Sort sort, int iDisplayStart, int iDisplayLength);

    List<CollectionDto> findCollectionByPageVoActivity(Conds conds, Sort sort, int iDisplayStart, int iDisplayLength,String openId);

    void updateexhibiadd(Collection collection);


}
