package com.cftech.cms.email_record.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author byj
 * @date: 2019-03-11 14:11
 */
@Data
public class Email_record implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /* 展会ID */
    @ExportConfig(value = "展会ID", width = 100)
    private Long exhibi_id;
    /* 邮箱 */
    @ExportConfig(value = "邮箱", width = 100)
    private String email;
    /* 用户OPENID */
    @ExportConfig(value = "用户OPENID", width = 100)
    private String open_id;
    /* 发送样本资料的ID */
    @ExportConfig(value = "发送样本资料的ID", width = 100)
    private String sample_id;
    /* 发送样本资料个数 */
    @ExportConfig(value = "发送样本资料个数", width = 100)
    private Long send_count;
    /* Zip压缩包路径*/
    private  String zip_url;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public Email_record() {
        this.delFlag = false;
        this.status = "0";
    }

}