/**
 * Created by liuling on 2017/5/25.
 * qtype:
 * SINGLESEL 单选
 * MULTISEL 多选
 * PICUPLOAD 图片上传
 * BLANKFILL 填空
 * TRUEFALSE 对错
 * PICSINGLESEL 图片单选
 * PICMULTISEL 图片多选
 */
var QSortable = (function () {
    'use strict';
    var QSortable = function(params) {
        var p = this;
        p.qSelects={};
        //参数定义
        p.params = {
            tarId: '',
            data: null
        };

        for (var param in params) {
            p.params[param] = params[param];

        }

        var getUniqueID = function (prefix) {
            if (!prefix || prefix == '') prefix = 'pf';
            return prefix + '_' + Math.floor(Math.random() * (new Date()).getTime());
        };

        var tid = '#'+p.params.tarId;


        //拖拽
        var sortableHtml =
            "<li id='{{id}}' class='list-group-item'  >"+
            "<div class='box box-default box-solid'>"+
            "<div class='box-header with-border'>"+
            "<h3 class='box-title'><span class='glyphicon glyphicon-th-list' ></span>问题信息</h3>"+
            "<div class='box-tools pull-right'>"+
            "<button type='button' class='btn btn-box-tool' data-widget='collapse'><i class='fa fa-minus'></i> </button>"+
            "<button type='button' class='btn btn-box-tool optionDel'><i class='glyphicon glyphicon-remove'></i> </button>"+
            "</div>"+
            "</div>"+
            "<div class='box-body'>"+
            "<div id='{{id}}-questionsDiv'></div>"+
            "</div>"+
            "</div>"+
            "</li>";


        p.buildTable = function () {
            p.selectQuestions( p.params.data);
             bindEvent();
        };

        var generateHtml = function (source, datas) {
            var template = Handlebars.compile(source);
            var htmlStr = template(datas);
            return htmlStr;
        };

        p.selectQuestions = function (data) {
            if(data!=null&&data!=""){
                var datas = JSON.parse(data) ;
                for(var i=0,j=datas.length;i<j;i++){
                    var obj=datas[i];
                    var id = getUniqueID('ss');
                    var htmlStr = '';
                    var type='';
                    htmlStr = generateHtml(sortableHtml,{id:id});
                    $(tid).append(htmlStr);
                    if(obj!=''){
                        obj.data=obj;
                        obj.datas=obj.options;
                        type=obj.type;
                        var qselect = new qSelect({
                            tarId: id+'-questionsDiv',
                            qtype: type,
                            data: obj
                        });
                        qselect.buildTable();
                        // var list={};
                        // eval("list."+id+"="+qselect);
                        p.qSelects[id]=qselect;
                    }
                }
            }

        };
        
        var bindEvent=function () {
            $(tid).on("click",".optionDel",function () {
                $(this).parent().parent().parent().parent().remove();
            })
        };

        var validateQuestions=function (datas) {
            var title=datas.title;
            var type=datas.type;
            var min=datas.min;
            var max=datas.max;
            if(title==''||title.trim()==''){//校验题目
                //alert("请输入问题！");
                return false;
            }
            if(min.length!=0){//校验最少可选几项
                var reg=/^[-+]?\d*$/;
                if(!reg.test(min)){
                   // alert("请正确输入数字项!");//请将“整数类型”要换成你要验证的那个属性名称！
                    return false;
                }
            }else{
                //alert('请填写数字项!');
                return false ;
            }
            if(max.length!=0){//校验最多可选几项
                var reg=/^[-+]?\d*$/;
                if(!reg.test(max)){
                    //alert("请正确输入数字项!");//请将“整数类型”要换成你要验证的那个属性名称！
                    return false;
                }
            }else{
                //alert('请填写数字项!');
                return false ;
            }

            if(type=='SINGLESEL'){//单选

                var options=datas.options;
                if(options==undefined){
                    //alert('请填写问题选项!');
                    return false;
                }

                var length=options.length;
                if(length==0){
                    //alert('请填写问题选项！');
                    return false;
                }else{
                    for(var i=0;i<length;i++){
                        var label=options[i].label;
                        var name =options[i].name;
                        if(label.trim()==''||name.trim()==''){
                            //alert('请正确填写问题选项!');
                            return false;
                        }
                    }
                }
            }else if(type=='MULTISEL'){
                var options=datas.options;
                if(options==undefined){
                    //alert('请填写问题选项!');
                    return false;
                }

                var length=options.length;
                if(length==0||length<=1){
                    //alert('请填写问题选项(多选题选择项最少为两项)！');
                    return false;
                }else{
                    for(var i=0;i<length;i++){
                        var label=options[i].label;
                        var name =options[i].name;
                        if(label.trim()==''||name.trim()==''){
                            //alert('请正确填写问题选项!');
                            return false;
                        }
                    }
                }
            }else if(type=='PICSINGLESEL'){
                var options=datas.options;
                if(options==undefined){
                    //alert('请填写问题选项!');
                    return false;
                }

                var length=options.length;
                if(length==0){
                    //alert('请填写问题选项！');
                    return false;
                }else{
                    for(var i=0;i<length;i++){
                        var label=options[i].label;
                        var name =options[i].name;
                        var pic=options.pic;
                        if(label.trim()==''||name.trim()==''||pic==''){
                            //alert('请正确填写问题选项!');
                            return false;
                        }
                    }
                }
            }else if(type=='PICMULTISEL'){
                var options=datas.options;
                if(options==undefined){
                    //alert('请填写问题选项!');
                    return false;
                }

                var length=options.length;
                if(length==0||length<=1){
                    //alert('请填写问题选项(多选题选择项最少为两项)！');
                    return false;
                }else{
                    for(var i=0;i<length;i++){
                        var label=options[i].label;
                        var name =options[i].name;
                        var pic=options.pic;
                        if(label.trim()==''||name.trim()==''||pic==''){
                            //alert('请正确填写问题选项!');
                            return false;
                        }
                    }
                }
            }else if(type=='BLANKFILL'){
                return true;
            } else {
                //alert('未知的问题类型!');
                return false;
            }
            return true;
        };

        p.getValues=function () {
            var flag=true;
            var arr=[];
            console.log(tid);

            $(tid+" li").each(function () {
                var id=$(this).attr("id");
                var data=p.qSelects[id].getValues();
                arr.push(data);
                if(!validateQuestions(data)){
                    flag=false;
                }
            });
            if(flag){
                return arr;
            }else{
                return [];
            }

        }

    };

    return QSortable;
})();