package com.cftech.invoice.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.invoice.model.Invoice;
import com.cftech.invoice.service.InvoiceService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;


/**
 * 开票信息Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String INVOICE_VIEW = "qy:invoice:view"
 * 查看:public static final String INVOICE_EDIT = "qy:invoice:edit"
 *
 * @author Buyj
 * @date: 2020-11-25 09:32
 */
@Slf4j
@Controller
@RequestMapping("/a/invoice")
public class InvoiceController {

    public static final String INVOICE_VIEW = "qy:invoice:view";
    public static final String INVOICE_EDIT = "qy:invoice:edit";

    @Autowired
    private InvoiceService invoiceService;


    //列表页面
    @RequiresPermissions(value = INVOICE_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "invoice/invoicelist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = INVOICE_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Invoice invoice = invoiceService.fetchById(id);
            if (!StringUtils.isEmpty(invoice.getInvoiceType())){
                invoice.setInvoiceType(invoice.getInvoiceType().equals("1") ? "蓝票" : "红票");
            }
            if (!StringUtils.isEmpty(invoice.getInvoiceForm())){
                invoice.setInvoiceForm(invoice.getInvoiceForm().equals("0") ? "移动端" : "后台");
            }
            if (!StringUtils.isEmpty(invoice.getPushMode())){
                invoice.setPushMode(invoice.getPushMode().equals("0") ? "邮箱" : "");
            }
            if (!StringUtils.isEmpty(invoice.getStatus())){
                invoice.setStatus(invoice.getStatus().equals("0") ? "个人" : "企业");
            }
            if (invoice.getCreateTime() != null){
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                invoice.setDescription(format.format(invoice.getCreateTime()));
            }
            model.addAttribute("data", invoice);
        }
        return "invoice/invoiceform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = INVOICE_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Invoice invoice, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (invoice != null && invoice.getId() != null) {
                invoice.setUpdateBy(UserUtils.getUser().getId());
                invoiceService.update(invoice);
                rtnJson.put("errorNo", 0);
            } else {
                invoice.setAccountsId(accountsId);
                invoice.setDelFlag(false);
                invoice.setAccountsId(UserUtils.getmpaccounts(request));
                invoice.setCreateBy(UserUtils.getUser().getId());
                invoice.setUpdateBy(UserUtils.getUser().getId());
                invoiceService.save(invoice);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = INVOICE_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Invoice invoice, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(invoice.getInvoiceTitle())){
            conds.like("invoice_title",invoice.getInvoiceTitle());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Invoice> list = invoiceService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = invoiceService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = INVOICE_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            invoiceService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = INVOICE_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response , Invoice invoice) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        if (!StringUtils.isEmpty(invoice.getInvoiceTitle())){
            conds.like("invoice_title",invoice.getInvoiceTitle());
        }
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        List<Invoice> list = invoiceService.fetchSearchByPage(conds, sort, 0, 0);
        if (list.size() > 0){
            for (Invoice invoiceObj : list) {
                invoiceObj.setInvoiceType(StringUtils.isEmpty(invoiceObj.getInvoiceType()) ? "" : invoiceObj.getInvoiceType().equals("1") ? "正票":"红票" );
                invoiceObj.setInvoiceForm(StringUtils.isEmpty(invoiceObj.getInvoiceForm()) ? "" : invoiceObj.getInvoiceForm().equals("0") ? "移动端" : "后台");
                invoiceObj.setPushMode(StringUtils.isEmpty(invoiceObj.getPushMode()) ? "" : "邮箱");
                invoiceObj.setStatus(StringUtils.isEmpty(invoiceObj.getStatus()) ? "" : invoiceObj.getStatus().equals("0") ? "个人" :"企业");
            }
        }
        ExcelKit.$Export(Invoice.class, response).toExcel(list, "开票信息信息");
    }

    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = INVOICE_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(Invoice.class, response).toExcel(null, "开票信息信息");
    }

    @RequestMapping("/importExcel")
    @RequiresPermissions(value = INVOICE_EDIT)
    public String importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        if (file == null) {
            return list(request, model);
        }
// 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().setEmptyCellValue("").readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    Invoice invoice = new Invoice();
                    invoice.setAccountsId(accountId);
                    invoiceService.save(invoice);
                }
            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }

        return list(request, model);
    }

}
