package com.cftech.questionnaire.core.questions.service;

import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.questionnaire.core.questions.model.Questions;

import java.util.List;

/**
* 问卷题库Service
*
* @author wxf
* @date: 2017-05-24 11:43
*/
public interface QuestionsService extends GenericService<Questions> {
    /**
     * 分页查询
     *
     * @param pId   哪个分类下的
     * @param conds    条件
     * @param sort     排序
     * @param page     起始条数
     * @param pageSize 分页大小
     * @return
     */
    List<Questions> fetchSearchVOByPage(Long pId, Conds conds, Sort sort, int page, int pageSize);

    int count(Long pId, Conds conds);

    void addpaperlog(String question);
}
