package org.mp.api.wxbase.wxmedia;

import com.cftech.cos.config.cosconfig.model.Cosconfig;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.mp.api.core.common.WxstoreUtils;
import org.mp.api.core.exception.WexinReqException;
import org.mp.api.core.req.WeiXinReqService;
import org.mp.api.core.req.model.DownloadMedia;
import org.mp.api.core.req.model.UploadMedia;
import org.mp.api.core.util.WeiXinConstant;
import org.mp.api.wxbase.wxmedia.model.*;
import org.mp.api.wxsendmsg.model.WxArticle;
import org.mp.api.wxsendmsg.model.WxArticlesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * 微信--token信息
 *
 * @author lizr
 */
public class JwMediaAPI {
    private static Logger logger = LoggerFactory.getLogger(JwMediaAPI.class);
    // 新增永久图文素材
    private static String material_add_news_url = "https://api.weixin.qq.com/cgi-bin/material/add_news?access_token=ACCESS_TOKEN";
    // 新增其他类型永久素材
    private static String material_add_material_url = "https://api.weixin.qq.com/cgi-bin/material/add_material?access_token=ACCESS_TOKEN&type=TYPE";
    // 获取永久素材
    private static String material_get_material_url = "https://api.weixin.qq.com/cgi-bin/material/get_material?access_token=ACCESS_TOKEN";
    // 获取素材总数
    private static String material_get_materialcount_url = "https://api.weixin.qq.com/cgi-bin/material/get_materialcount?access_token=ACCESS_TOKEN";
    // 修改永久图文素材
    private static String material_update_news_url = "https://api.weixin.qq.com/cgi-bin/material/update_news?access_token=ACCESS_TOKEN";
    // 获取素材列表
    private static String material_batchget_material_url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=ACCESS_TOKEN";

    /**
     * @param accessToke
     * @param type         媒体文件类型，分别有图片（image）、语音（voice）、视频（video）和缩略图（thumb）
     * @param fileNamePath 上传的文件目录
     * @return
     * @throws WexinReqException
     */
    public static WxUpload uploadMedia(String accessToke, String type, String fileNamePath) throws WexinReqException {
        UploadMedia uploadMedia = new UploadMedia();
        uploadMedia.setAccess_token(accessToke);
        uploadMedia.setFilePathName(fileNamePath);
        uploadMedia.setType(type);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(uploadMedia);
        Object error = result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
        WxUpload wxMedia = null;
        wxMedia = (WxUpload) JSONObject.toBean(result, WxUpload.class);
        return wxMedia;
    }


    /**
     * 下载多媒体
     *
     * @param accessToke
     * @param media_id
     * @param filePath
     * @return
     * @throws WexinReqException
     */
    public static JSONObject downMedia(String accessToke, String media_id, String filePath, Cosconfig cosconfig) throws WexinReqException {
        DownloadMedia downloadMedia = new DownloadMedia();
        downloadMedia.setAccess_token(accessToke);
        downloadMedia.setFilePath(filePath);
        downloadMedia.setMedia_id(media_id);
        downloadMedia.setCosconfig(cosconfig);
        JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(downloadMedia);
        Object error = result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
        return result;
//        WxDwonload wxMedia = null;
//        wxMedia = (WxDwonload) JSONObject.toBean(result, WxDwonload.class);
    }






//	public static void main(String[] args){
//		 
//		try {
//			/*WxUpload s = WeixinMediaService.uploadMedia(
//					"kY9Y9rfdcr8AEtYZ9gPaRUjIAuJBvXO5ZOnbv2PYFxox__uSUQcqOnaGYN1xc4N1rI7NDCaPm_0ysFYjRVnPwCJHE7v7uF_l1hI6qi6QBsA",
//					"image","C:/Users/sfli.sir/Desktop/temp/2457331_160355071353_2.jpg");*/
//			WxDwonload d = JwMediaAPI.downMedia(
//					"kY9Y9rfdcr8AEtYZ9gPaRUjIAuJBvXO5ZOnbv2PYFxox__uSUQcqOnaGYN1xc4N1rI7NDCaPm_0ysFYjRVnPwCJHE7v7uF_l1hI6qi6QBsA",
//					"wBSDL0sz3zqOSGEXG9kIht48V9W7pAQBK50rFKFx1dv6FXsVNROxcxLPMUa9L-yI",
//					"C:/Users/sfli.sir/Desktop/temp/");
//			System.out.println(d.getFileName());
//		} catch (WexinReqException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//	}

    /**
     * 上传新增永久图文素材
     *
     * @param accesstoken
     * @param wxArticles  图文集合，数量不大于10
     * @return WxArticlesResponse 上传图文消息素材返回结果
     * @throws WexinReqException
     */
    public static WxArticlesResponse uploadArticlesByMaterial(String accesstoken, List<WxArticle> wxArticles) throws WexinReqException {
        WxArticlesResponse wxArticlesResponse = null;
        if (wxArticles.size() == 0) {
            logger.error("没有上传的图文消息");
        } else if (wxArticles.size() > 10) {
            logger.error("图文消息最多为10个图文");
        } else {
            if (accesstoken != null) {
                String requestUrl = material_add_news_url.replace("ACCESS_TOKEN", accesstoken);

//				for (WxArticle article : wxArticles) {
//					if (article.getFileName() != null && article.getFileName().length() > 0) {
//						try {
//							String mediaId = JwSendMessageAPI.getFileMediaId(accesstoken, article);
//							article.setThumb_media_id(mediaId);
//
//						} catch (Exception e) {
//							throw new WexinReqException(e);
//						}
//					}
//				}

                WxArticlesRequest wxArticlesRequest = new WxArticlesRequest();
                wxArticlesRequest.setArticles(wxArticles);
                JSONObject obj = JSONObject.fromObject(wxArticlesRequest);
                JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
                //System.out.println("微信返回的结果：" + result.toString());
                if (result.has("errcode")) {
                    logger.error("上传图文消息失败！errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
                    throw new WexinReqException("上传图文消息失败！errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
                } else {
                    wxArticlesResponse = new WxArticlesResponse();
                    wxArticlesResponse.setMedia_id(result.getString("media_id"));
                    //wxArticlesResponse.setType(result.getString("type"));
                    //wxArticlesResponse.setCreated_at(new Date(result.getLong("created_at") * 1000));
                }

            }
        }

        return wxArticlesResponse;
    }


    /**
     * 获取素材总数
     *
     * @param accesstoken
     * @param accesstoken
     * @return WxCountResponse 素材数目返回结果
     * @throws WexinReqException
     */
    public static WxCountResponse getMediaCount(String accesstoken) throws WexinReqException {
        WxCountResponse wxCountResponse = null;
        if (accesstoken != null) {
            String requestUrl = material_get_materialcount_url.replace("ACCESS_TOKEN", accesstoken);

            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", null);
            //System.out.println("微信返回的结果：" + result.toString());
            if (result.has("errcode")) {
                logger.error("上传图文消息失败！errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
                throw new WexinReqException("上传图文消息失败！errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
            } else {

                wxCountResponse = new WxCountResponse();
                wxCountResponse.setImage_count(result.getString("image_count"));
                wxCountResponse.setNews_count(result.getString("news_count"));
                wxCountResponse.setVideo_count(result.getString("video_count"));
                wxCountResponse.setVoice_count(result.getString("voice_count"));
            }
        }
        return wxCountResponse;
    }

    /**
     * 获取永久素材
     *
     * @param accesstoken
     * @return WxArticlesResponse 上传图文消息素材返回结果
     * @throws WexinReqException
     */
    public static WxArticlesRespponseByMaterial getArticlesByMaterial(String accesstoken, String mediaId) throws WexinReqException {
        WxArticlesRespponseByMaterial wxArticlesRespponseByMaterial = null;

        if (accesstoken != null) {
            String requestUrl = material_get_material_url.replace("ACCESS_TOKEN", accesstoken);

            JSONObject paramsJson = new JSONObject();
            paramsJson.put("media_id",mediaId);

            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", paramsJson.toString());
            //System.out.println("微信返回的结果：" + result.toString());
            if(result==null){
                return null;
            }
            if (result.has("errcode")) {
                logger.error("获得消息失败！errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
                throw new WexinReqException("获得消息失败！errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
            } else {
                wxArticlesRespponseByMaterial = (WxArticlesRespponseByMaterial) JSONObject.toBean(result, WxArticlesRespponseByMaterial.class);
            }
        }

        return wxArticlesRespponseByMaterial;
    }

    /**
     * 删除永久素材
     *
     * @param accesstoken
     * @param mediaId     图文集合，数量不大于10
     * @return WxArticlesRespponseByMaterial 上传图文消息素材返回结果
     * @throws WexinReqException
     */
    public static void deleteArticlesByMaterial(String accesstoken, String mediaId) throws WexinReqException {
        if (accesstoken != null && StringUtils.isNotEmpty(mediaId)) {
            String requestUrl = material_get_material_url.replace("ACCESS_TOKEN", accesstoken);
            WxArticlesRequestByMaterial wxArticlesRequestByMaterial = new WxArticlesRequestByMaterial();
            wxArticlesRequestByMaterial.setMediaId(mediaId);
            JSONObject obj = JSONObject.fromObject(wxArticlesRequestByMaterial);
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            //System.out.println("微信返回的结果：" + result.toString());
            if (result.has("errcode") && result.get("errcode") != "0") {
                logger.error("删除消息失败！errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
                throw new WexinReqException("删除消息失败！errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
            }
        }
    }

    /**
     * 修改永久素材
     *
     * @param accesstoken
     * @param wxUpdateArticle
     * @throws WexinReqException
     */
    public static void updateArticlesByMaterial(String accesstoken, WxUpdateArticle wxUpdateArticle) throws WexinReqException {
        if (accesstoken != null) {
            String requestUrl = material_update_news_url.replace("ACCESS_TOKEN", accesstoken);

            JSONObject obj = JSONObject.fromObject(wxUpdateArticle);
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            //System.out.println("微信返回的结果：" + result.toString());
            if (result.has("errcode") && result.get("errcode") != "0") {
                logger.error("消息失败！errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
                throw new WexinReqException("消息消息失败！errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
            }
        }
    }

    /**
     * 获取素材列表
     *
     * @param accesstoken,type,offset,count
     * @throws WexinReqException
     */
    public static JSONObject queryArticlesByMaterial(String accesstoken, String type, int offset, int count) throws WexinReqException {
        JSONObject obj = new JSONObject();
        JSONObject result = null;
        if (accesstoken != null) {
            String requestUrl = material_batchget_material_url.replace("ACCESS_TOKEN", accesstoken);
            obj.put("type", type);
            obj.put("offset", offset);
            obj.put("count", count);
            result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            //System.out.println("微信返回的结果：" + result.toString());
            if (result.has("errcode") && result.get("errcode") != "0") {
                logger.error("消息失败！errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
                throw new WexinReqException("消息消息失败！errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
            }
        }
        return result;
    }

    /**
     * 新增永久图文素材
     *
     * @param accesstoken
     * @param wxArticles
     * @return
     * @throws WexinReqException
     */
    public static WxArticlesResponse getMediaIdByMaterial(String accesstoken, List<WxArticle> wxArticles) throws WexinReqException {

        WxArticlesResponse response = uploadArticlesByMaterial(accesstoken, wxArticles);
        if (response == null) {
            throw new WexinReqException("获取图文的mediaId失败");
        }
        return response;
    }

    /**
     * 新增其他类型永久素材
     * <p>
     * 媒体文件类型，分别有图片（image）、语音（voice）、视频（video）和缩略图（thumb）
     *
     * @return
     * @throws Exception
     */
    public static WxMediaForMaterialResponse uploadMediaFileByMaterial(String accesstoken, WxMediaForMaterial wx) throws WexinReqException {
        WxMediaForMaterialResponse mediaResource = null;
        if (accesstoken != null) {
            String requestUrl = material_add_material_url.replace("ACCESS_TOKEN", accesstoken).replace("TYPE", wx.getType());
            //String contentType = WeiXinReqUtil.getFileContentType(wx.getFileName().substring(wx.getFileName().lastIndexOf(".") + 1));
            if ("video" == wx.getType()) {
                String video = "&description={\"title\":VIDEO_TITLE, \"introduction\":INTRODUCTION}";
                video.replace("VIDEO_TITLE", wx.getWxDescription().getTitle()).replace("INTRODUCTION", wx.getWxDescription().getIntroduction());
                requestUrl += video;
            }
            mediaResource = WxstoreUtils.uploadPermanentMedia(requestUrl, wx);
        }
        return mediaResource;
    }

    /**
     * 永久获取多媒体资源的mediaId
     *
     * @param accesstoken
     * @return
     * @throws WexinReqException
     */
    public static String getMediaIdForMaterial(String accesstoken, WxMediaForMaterial wxMediaForMaterial) throws WexinReqException {

        WxMediaForMaterialResponse response = uploadMediaFileByMaterial(accesstoken, wxMediaForMaterial);
        if (response == null) {
            throw new WexinReqException("获取多媒体资源的mediaId失败");
        }
        return response.getMedia_id();

    }

//	public static void main(String[] args) {
//		WxMediaForMaterial wx = new WxMediaForMaterial();
//		File file = new File("C:\\Users\\Administrator\\Desktop\\yueliang-007.jpg");
//		wx.setFileName(file.getName());
//		wx.setType("image");
//		wx.setFilePath("C:\\Users\\Administrator\\Desktop\\yueliang-007.jpg");
//		try {
//			getMediaIdForMaterial("f2MFD5v5C_NuIbu4GVG7WSN3r19tK0_GEhQggZWFjBMc8tltDvl4gY67DNtHL36mV8bHcQV4jhs1ppIhHc-Qoi40ssDkBUxFdQvrTZT04D4DUZcAEAQHM",wx);
//		} catch (WexinReqException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//	}

    /**
     * 获取图文列表测试
     *
     * @throws WexinReqException
     */
    public static void main(String[] args) throws WexinReqException {
//		WxNews news = queryArticlesByMaterial("BrL3GDLeenKGvQ_k2JSmVEPAFxSeoA_86ZzTVWRGKOQ5VYZ66nB0rWgcwm0TYXwwOiYptf-FJYzx6Kx-NrVqdMLKm7aPB5495ClTYFKY0IYzye0KHr6bLEteNuxl--FQGLYiABARWJ","news",1,10);
//		System.out.println(news);
        WxArticlesRespponseByMaterial wx =getArticlesByMaterial("L3RcgBTs7wfG5K86ryUP7ZCyyPoKZygCBnExgFw4p8kIW8PtRpMYmDVnCjZmAwuHE_SxPrbjExqyrNgRf35PTZAtIFD693spzfg4Ut8SjzU6tHTAV739YfcjKNUa-l5rNYWjAAAQBZ","pVgkatFrLlsrQ3OlhvMCBpyHgKPNmG8r9KGbwPd_tvo");

    }
}
