package com.cftech.activity.market.sign.service.impl;

import com.cftech.activity.market.sign.dao.SignMapper;
import com.cftech.activity.market.sign.model.Sign;
import com.cftech.activity.market.sign.model.SignDto;
import com.cftech.activity.market.sign.service.SignService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* 市场活动签到ServiceImpl
*
* @author faye
* @date: 2017-08-28 13:39
*/
@Service("signService")
public class SignServiceImpl extends GenericServiceImpl<Sign> implements SignService {

@Autowired
@Qualifier("signMapper")
private SignMapper signMapper;

@Override
public GenericDao<Sign> getGenericMapper() {
return signMapper;
}

    @Override
    public int countVo(Conds conds) {
        Map<String,Object> params=new HashMap<String, Object>();
        params.put("conds",conds);
        return signMapper.countVo(params);
    }

    @Override
    public List<SignDto> fetchSearchByPageVo(Conds conds,Sort sort,int page,int pageSize) {
        Map<String,Object> params=new HashMap<String, Object>();
        params.put("conds",conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return signMapper.fetchSearchByPageVo(params);
    }
}