package com.cftech.activity.record.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lisw
 * @date: 2017-10-12 17:32
 */
@Data
public class OilRecord implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /* 会员ID */
    @ExportConfig(value = "会员ID", width = 100)
    private Long memberId;
    /* 增加或减少 0:增加  1:减少 */
    @ExportConfig(value = "增加或减少 0:增加  1:减少", width = 100)
    private String type;
    /* 额度 */
    @ExportConfig(value = "额度", width = 100)
    private String quota;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    private String cardIds;

    public OilRecord() {
        this.delFlag = false;
        this.status = "0";
    }

}