package com.cftech.mp.area.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.mp.area.model.Area;
import com.cftech.mp.area.model.AreaDto;
import com.cftech.mp.area.service.AreaService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by lisw on 2017/10/10.
 * 地区选择手机端接口
 */
@Slf4j
@RestController
@RequestMapping("/mobile/auth/area")
public class MobileAreaController {

    @Autowired
    private AreaService areaService;

    @Autowired
    private RedisTemplate redisTemplate;


    /**
     * 序列化Redis
     *
     * @return
     */
    public boolean init() {
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer(stringSerializer);
        //redisTemplate.setValueSerializer(stringSerializer);
        redisTemplate.setHashKeySerializer(stringSerializer);
        redisTemplate.setHashValueSerializer(stringSerializer);
        return true;
    }

    /**
     * 获取所有省份
     *
     * @return
     */
    @RequestMapping(value = "province", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject provinceList(Long accountsId) {
        init();
        JSONObject rtnJson = new JSONObject();
        try {
            Sort sort = new Sort("sort", OrderType.ASC);
            Conds conds = new Conds();
            conds.equal("citytype", "1");
            conds.equal("delflag", 0);
            List<Area> areaList = new ArrayList<Area>();
            areaList = areaService.fetchSearchByPage(conds, sort, 0, 0);
            rtnJson.put("errorNo", 0);
            rtnJson.put("datas", areaList);
        } catch (Exception e) {
            e.printStackTrace();
            log.info("获取省份出现异常" + e.getMessage());
        }
        return rtnJson;
    }


    /**
     * 根据省份ID获取城市列表
     *
     * @return
     */
    @RequestMapping(value = "city", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject cityList(Long areaId) {
        init();
        JSONObject rtnJson = new JSONObject();
        try {
            Sort sort = new Sort("sort", OrderType.ASC);
            Conds conds = new Conds();
            conds.equal("affiliationareaid", areaId);
            conds.equal("delflag", 0);
            List<Area> areaList = areaService.fetchSearchByPage(conds, sort, 0, 0);
            rtnJson.put("errorNo", 0);
            rtnJson.put("datas", areaList);
        } catch (Exception e) {
            e.printStackTrace();
            log.info("获取城市出现异常" + e.getMessage());
        }
        return rtnJson;
    }

    /**
     * 获取省市JSON数据
     */
    @RequestMapping(value = { "/provinceCity" }, method = RequestMethod.GET, produces = { "application/json;charset=UTF-8" })
    public JSONObject provinceCity(){
        JSONObject rtnJson = new JSONObject();
        try {
            List<AreaDto> areaList =  areaService.areaList();
            rtnJson.put("errorNo",0);
            rtnJson.put("data",areaList);
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }


}
