package com.cftech.shop.qrcode.service;

import com.cftech.shop.qrcode.model.QyUser;
import com.cftech.shop.qrcode.model.WxQrcode;
import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.shop.qrcode.model.vo.WxQrcodeVO;

import java.util.List;

/**
 * 二维码Service
 *
 * @author Neil
 * @date: 2017-12-04 17:56
 */
public interface WxQrcodeService extends GenericService<WxQrcode> {

    List<WxQrcode> fetchSearchByPage(Long orgId, Conds conds, Sort sort, int page, int pageSize);

    List<WxQrcodeVO> fetchSearchByPageVO(Conds conds, Sort sort, int page, int pageSize);

    int count(Long orgId, Conds conds);

    boolean updateBindId(WxQrcode wxQrcode);

    List<WxQrcode> fetchSingleSearchInfo(Conds conds, Sort sort, int page, int pageSize);

    List<QyUser> fromUser(int type, String name, String allergy, int iDisplayStart, int iDisplayLength);

    int countUser(int type, String name, String allergy);

    List<WxQrcode> fromOrg(String outSide, String name, int iDisplayStart, int iDisplayLength);

    int countOrg(String outSide, String name);
}
