package com.cftech.report.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 报表信息
 *
 * @author Buyj
 * @date: 2020-12-02 11:26
 */
@Data
public class Report implements Serializable {

    /* 主键id */
    private Long id;
    /* 大区 */
    @ExportConfig(value = "大区", width = 100, showLevel = 1)
    private String region;
    /* 省份 */
    @ExportConfig(value = "省份", width = 100, showLevel = 1)
    private String province;
    /* 城市 */
    @ExportConfig(value = "城市", width = 100, showLevel = 1)
    private String city;
    /* 销售代表 */
    @ExportConfig(value = "销售代表", width = 100, showLevel = 1)
    private String salesRepresent;
    /* 医院 */
    @ExportConfig(value = "医院", width = 100, showLevel = 1)
    private String hospital;
    /* 科室 */
    @ExportConfig(value = "科室", width = 100, showLevel = 1)
    private String department;
    /* 医生姓名 */
    @ExportConfig(value = "医生姓名", width = 100, showLevel = 1)
    private String doctorName;
    /* 医生职称 */
    @ExportConfig(value = "医生职称", width = 100, showLevel = 1)
    private String doctorTitle;
    /* 性别 */
    @ExportConfig(value = "性别", width = 100, showLevel = 1)
    private String sex;
    /* 医生手机号码 */
    @ExportConfig(value = "医生手机号码", width = 100, showLevel = 1)
    private String doctorPhone;
    /* 处方医院 */
    @ExportConfig(value = "处方医院", width = 100, showLevel = 1)
    private String cfHospital;
    /* 处方医生 */
    @ExportConfig(value = "处方医生", width = 100, showLevel = 1)
    private String cfDoctor;
    /* 咨询单编码 */
    @ExportConfig(value = "咨询单编码", width = 100, showLevel = 1)
    private String consultNumber;
    /* 需求清单编码 */
    @ExportConfig(value = "需求清单编码", width = 100, showLevel = 1)
    private String orderNumber;
    /* 用户姓名 */
    @ExportConfig(value = "用户姓名", width = 100, showLevel = 1)
    private String userName;
    /* 用户手机号码 */
    @ExportConfig(value = "用户手机号码", width = 100, showLevel = 1)
    private String phone;
    /* 产品名称 */
    @ExportConfig(value = "产品名称", width = 100, showLevel = 1)
    private String productName;
    /* 购买数量 */
    @ExportConfig(value = "购买数量", width = 100, showLevel = 1)
    private String drugsNum;
    /* 付款时间 */
    @ExportConfig(value = "付款时间", width = 100, showLevel = 1)
    private Date fkTime;
    /* 发货时间 */
    @ExportConfig(value = "发货时间", width = 100, showLevel = 1)
    private Date fhTime;
    /* 收件时间 */
    @ExportConfig(value = "收件时间", width = 100, showLevel = 1)
    private Date sjTime;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;
    /**
     * 用户的opendId
     */
    private String openId;

    public Report() {
        this.delFlag = false;
        this.status = "0";
    }

}