package com.cftech.productdetail.service.impl;

import com.cftech.productdetail.model.ProductDetail;
import com.cftech.productdetail.dao.ProductDetailMapper;
import com.cftech.productdetail.service.ProductDetailService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
 * 产品详情ServiceImpl
 *
 * @author Buyj
 * @date: 2020-09-28 17:08
 */
@Service("productDetailService")
public class ProductDetailServiceImpl extends GenericServiceImpl<ProductDetail> implements ProductDetailService {

    @Autowired
    @Qualifier("productDetailMapper")
    private ProductDetailMapper productDetailMapper;

    @Override
    public GenericDao<ProductDetail> getGenericMapper() {
        return productDetailMapper;
    }

}