package com.cftech.logistics.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.logistics.model.Logistics;
import com.cftech.logistics.dao.LogisticsMapper;
import com.cftech.logistics.service.LogisticsService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* 物流信息ServiceImpl
*
* @author Buyj
* @date: 2020-11-29 17:19
*/
@Service("logisticsService")
public class LogisticsServiceImpl extends GenericServiceImpl<Logistics> implements LogisticsService {

@Autowired
@Qualifier("logisticsMapper")
private LogisticsMapper logisticsMapper;

@Override
public GenericDao<Logistics> getGenericMapper() {
return logisticsMapper;
}

    @Override
    public Integer countList(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return logisticsMapper.countList(params);
    }

    @Override
    public List<Logistics> fetchSearchByList(Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return logisticsMapper.fetchSearchByList(params);
    }
}