package com.cftech.invoice.model;

import lombok.Data;

/**
 *
 * 移动端查看发票实体类
 * @author BuYJ
 */
@Data
public class InvoiceDetail {

    /**
     * 发票id
     */
    private String id;
    /**
     * 订单编码
     */
    private String number;

    /**
     * 订单下单时间
     */
    private String createTime;

    /**
     * 是否开票  有值则已开票  反之则未
     */
    private String confirm;

    /**
     * 订单状态 0:待确认 1:待付款 2:待发货 3:待收货 4:已完成(已成交) 5:已取消
     */
    private String status;

    /**
     * 开票金额
     */
    private String totalAmount;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品规格
     */
    private String format;

    /**
     * 产品单位
     */
    private String unit;

    /**
     * 产品单价
     */
    private String price;

    /**
     * 产品图片
     */
    private String productImg;

    /**
     * 是否RS
     */
    private String isRs;

    /**
     * 抬头名称
     */
    private String invoiceTitle;

    /**
     *  发票类型（1：蓝票，2红票）
     */
    private String invoiceType;

    /**
     * 发票内容
     */
    private String invoiceContent;

    /**
     *  抬头类型( 0:个人  1:企业 )
     */
    private String invoiceStatus;

    /**
     * 申请时间
     */
    private String invoiceCreateTime;


    /**
     * 移动端传的APPID
     */
    private String appId;

}
