import { TableColumnSchema, FormSchema } from 'link-components';
import { createOpenTitle, createSwitch } from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {
      title: 'parentId',
      field: 'parentId',
      visible: false,
    },
    {type: 'seq',title: '序号', width: 60},
    {
      title: '分组编码',
      field: 'groupId',
      sortable: true,
      width: 130,
    },
    {
      title: '编号',
      sortable: true,
      field: 'id',
      treeNode: true,
      width: 180,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'id');
      }
    },
    {
      title: '名称',
      field: 'name',
      sortable: true,
      width: 200,
    },
    {
      title: '是否启用',
      field: 'isEnable',
      sortable: true,
      width: 100,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      title: '排序号',
      field: 'seq',
      sortable: true,
      width: 100,
    },
    {
      title: '备注',
      field: 'remake',
      width: 200,
    },
  ];
}


export function formGroupSchema(getDictGroupTreeData: any) :FormSchema[]{
  return [
    {
      field: 'code',
      title: '编码',
      component: 'Input',
      show: false,
    },
    {
      field: 'id',
      title: '编码',
      component: 'Input',
      required: true,
    },
    {
      field: 'name',
      title: '名称',
      required: true,
      component: 'Input',
    },
    {
      field: 'parentId',
      title: '上级分组',
      required: true,
      component: 'TreeSelect',
        componentProps:{
          api: getDictGroupTreeData,
          filterable: true,
          clearable: true,
        }
    },
    {
      field: 'remake',
      title: '备注',
      component: 'Input',
      componentProps: {
        type: 'textarea'
      }
    },
  ];
}



export function formSchema(getDictGroupTreeData: any) :FormSchema[]{
  return [
    {
      field: 'code',
      title: '编码',
      component: 'Input',
      show: false,
    },
    {
      field: 'groupId',
      title: '所属分组',
      required: true,
      component: 'TreeSelect',
      disabled: true,
      componentProps:{
        api: getDictGroupTreeData,
        filterable: true,
        clearable: true,
      }
    },
    {
      field: 'id',
      title: '编码',
      component: 'Input',
      required: true,
    },
    {
      field: 'name',
      title: '名称',
      required: true,
      component: 'Input',
    },
    {
      field: 'seq',
      title: '排序号',
      component: 'InputNumber',
      required: true,
    },
    {
      field: 'parentId',
      title: '关联上级',
      component: 'BindDict',
      componentProps: ({formModel}) => {
        return {
          type: 'TreeSelect',
          billVo: 'com.link.jiandanbiao.sys.vo.DictTypeVo',
          fields: 'id,name',
          serviceName: 'link-system-start',
          dynFilter: `group_id = '${formModel.groupId}'`,
          props: {
            label: 'name',
            value: 'id',
          },
          clearable: true
        }
      }
    },
    {
      field: 'remake',
      title: '备注',
      component: 'Input',
      componentProps: {
        type: 'textarea'
      }
    },
  ];
}

